/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.sdk;

import com.smartbear.har.builder.HarContentBuilder;
import com.smartbear.har.builder.HarCookieBuilder;
import com.smartbear.har.builder.HarEntryBuilder;
import com.smartbear.har.builder.HarHeaderBuilder;
import com.smartbear.har.builder.HarPostDataBuilder;
import com.smartbear.har.builder.HarRequestBuilder;
import com.smartbear.har.builder.HarResponseBuilder;
import com.smartbear.har.creator.DefaultHarStreamWriter;
import com.smartbear.har.model.HarContent;
import com.smartbear.har.model.HarCookie;
import com.smartbear.har.model.HarCreator;
import com.smartbear.har.model.HarHeader;
import com.smartbear.har.model.HarPostData;
import com.smartbear.har.model.HarRequest;
import com.smartbear.har.model.HarResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.BinaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;

public class SpeakeasyHarBuilder {
    private final String cookieResponseHeaderName = "Set-Cookie";
    private final DefaultHarStreamWriter.Builder harWriterBuilder;
    private OutputStream outputStream;
    private String comment;
    private Date startTime = new Date();
    private Date endTime = new Date();
    private String hostName;
    private String port;
    private HarCreator creator;
    private HarRequest harRequest;
    private HarResponse harResponse;

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public String getComment() {
        return this.comment;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getPort() {
        return this.port;
    }

    public HarCreator getCreator() {
        return this.creator;
    }

    public HarRequest getHarRequest() {
        return this.harRequest;
    }

    public HarResponse getHarResponse() {
        return this.harResponse;
    }

    public SpeakeasyHarBuilder() {
        this.harWriterBuilder = new DefaultHarStreamWriter.Builder();
    }

    public SpeakeasyHarBuilder withStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public SpeakeasyHarBuilder withEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public SpeakeasyHarBuilder withHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public SpeakeasyHarBuilder withPort(int port) {
        this.port = String.valueOf(port);
        return this;
    }

    public SpeakeasyHarBuilder withRequest(HttpServletRequest request, ByteArrayOutputStream requestOutputStream, Logger logger) throws IOException {
        BinaryOperator<List<String>> merge = new BinaryOperator<List<String>>(){

            @Override
            public List<String> apply(List<String> o, List<String> o2) {
                o.addAll(o2);
                return o;
            }
        };
        Map<String, List<String>> headerMap = null;
        if (request.getHeaderNames() != null) {
            headerMap = Collections.list(request.getHeaderNames()).stream().collect(Collectors.toMap(h2 -> h2, h2 -> Collections.list(request.getHeaders((String)h2)), merge));
        }
        ArrayList<HarCookie> harCookieList = new ArrayList();
        if (request.getCookies() != null) {
            harCookieList = Arrays.stream(request.getCookies()).map(c -> {
                HarCookieBuilder cookieBuilder = new HarCookieBuilder();
                try {
                    cookieBuilder.withName(c.getName()).withValue(c.getValue());
                }
                catch (Exception e) {
                    logger.debug("speakeasy-sdk:", e);
                }
                return cookieBuilder.build();
            }).collect(Collectors.toList());
        }
        ArrayList<HarHeader> harHeaderList = new ArrayList<HarHeader>();
        Enumeration<String> headerNames = request.getHeaderNames();
        while (headerNames != null && headerNames.hasMoreElements()) {
            try {
                String name = headerNames.nextElement();
                harHeaderList.add(new HarHeaderBuilder().withName(name).withValues(Collections.list(request.getHeaders(name))).build());
            }
            catch (Exception e) {
                logger.debug("speakeasy-sdk: ", e);
            }
        }
        if (requestOutputStream.size() == 0) {
            try {
                while (request.getInputStream().read() != -1) {
                }
                request.getInputStream().close();
            }
            catch (Exception e) {
                logger.error("speakeasy-sdk:", e);
            }
        }
        HarPostData postData = new HarPostDataBuilder().withMimeType(request.getContentType()).withText(requestOutputStream.toString()).build();
        String queryString = StringUtils.hasText(request.getQueryString()) ? request.getQueryString() : "";
        HarRequestBuilder builder = new HarRequestBuilder().withBodySize(request.getContentLengthLong()).withCookies(harCookieList).withHeaders(harHeaderList).withHeadersSize(this.calculateHeaderSize(headerMap)).withHttpVersion(request.getProtocol()).withMethod(request.getMethod()).withQueryString(queryString).withUrl(request.getRequestURI());
        if (requestOutputStream.size() > 0) {
            builder.withPostData(postData);
        }
        this.harRequest = builder.build();
        return this;
    }

    public SpeakeasyHarBuilder withResponse(HttpServletResponse response, ByteArrayOutputStream responseOutputStream, String httpVersion, Logger logger) {
        String contentType;
        if (response == null) {
            return this;
        }
        Map<String, List<String>> headerMap = null;
        List<HarCookie> harCookieList = null;
        List<HarHeader> harHeaderList = null;
        if (response.getHeaderNames() != null) {
            headerMap = response.getHeaderNames().stream().collect(Collectors.toMap(h2 -> h2, h2 -> new ArrayList<String>(response.getHeaders((String)h2))));
            harCookieList = response.getHeaderNames().stream().filter(header -> "Set-Cookie".equals(header)).flatMap(headerName -> response.getHeaders((String)headerName).stream().map(hv -> this.parseSetCookieString((String)hv))).collect(Collectors.toList());
            harHeaderList = response.getHeaderNames().stream().map(headerName -> new HarHeaderBuilder().withName((String)headerName).withValues(new ArrayList<String>(response.getHeaders((String)headerName))).build()).collect(Collectors.toList());
        }
        if (!StringUtils.hasText(contentType = response.getContentType())) {
            contentType = "application/octet-stream";
        }
        try {
            responseOutputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long contentSize = responseOutputStream.toByteArray().length;
        HarContent harContent = new HarContentBuilder().withSize(contentSize).withText(responseOutputStream.toString()).withMimeType(contentType).build();
        String redirectURL = "";
        Collection<String> locationHeaders = response.getHeaders("Location");
        if (locationHeaders != null && locationHeaders.size() > 0) {
            redirectURL = locationHeaders.iterator().next();
        }
        long bodySize = contentSize;
        if (response.getStatus() == 304) {
            bodySize = 0L;
        }
        int statusCode = response.getStatus();
        String statusText = null;
        try {
            statusText = HttpStatus.valueOf(statusCode).getReasonPhrase();
        }
        catch (Exception e) {
            logger.debug("speakeasy-api: ", e);
        }
        this.harResponse = new HarResponseBuilder().withStatus(statusCode).withStatusText(statusText).withCookies(harCookieList).withContent(harContent).withBodySize(bodySize).withHeaders(harHeaderList).withHeadersSize(this.calculateHeaderSize(headerMap)).withHttpVersion(httpVersion).withRedirectURL(redirectURL).build();
        return this;
    }

    public SpeakeasyHarBuilder withOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        return this;
    }

    public SpeakeasyHarBuilder withComment(String comment) {
        this.comment = comment;
        return this;
    }

    public SpeakeasyHarBuilder withCreator(HarCreator creator) {
        this.creator = creator;
        return this;
    }

    private HarCookie parseSetCookieString(String cookie) {
        String[] cookieParts;
        HarCookieBuilder cookieBuilder = new HarCookieBuilder();
        for (String cookiePart : cookieParts = cookie.split("; ")) {
            String cookieRegex = "([^=]+)=?([^=]*)";
            Pattern pattern = Pattern.compile(cookieRegex);
            Matcher matcher = pattern.matcher(cookiePart);
            block19: while (matcher.find()) {
                String key = matcher.group(1);
                String value = matcher.group(2);
                switch (key.toLowerCase()) {
                    case "domain": {
                        cookieBuilder.withDomain(value);
                        continue block19;
                    }
                    case "max-age": {
                        int maxAge = Integer.parseInt(value);
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(this.startTime);
                        calendar.add(13, maxAge);
                        SimpleDateFormat outFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
                        outFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                        String expires = outFormat.format(calendar.getTime());
                        cookieBuilder.withExpires(expires);
                        continue block19;
                    }
                    case "expires": {
                        String expires;
                        SimpleDateFormat outFormat;
                        try {
                            SimpleDateFormat inFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                            Date expiresDate = inFormat.parse(value);
                            outFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
                            outFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                            expires = outFormat.format(expiresDate);
                            cookieBuilder.withExpires(expires);
                        }
                        catch (Exception exception) {}
                        continue block19;
                    }
                    case "httponly": {
                        cookieBuilder.withHttpOnly(true);
                        continue block19;
                    }
                    case "path": {
                        cookieBuilder.withPath(value);
                        continue block19;
                    }
                    case "secure": {
                        cookieBuilder.withSecure(true);
                        continue block19;
                    }
                }
                cookieBuilder.withName(key);
                cookieBuilder.withValue(value);
            }
        }
        return cookieBuilder.build();
    }

    public void build() throws IOException {
        DefaultHarStreamWriter harWriter = this.harWriterBuilder.withOutputStream(this.outputStream).withComment(this.comment).withCreator(this.creator).build();
        HarEntryBuilder builder = new HarEntryBuilder().withRequest(this.harRequest).withResponse(this.harResponse).withServerIPAddress(this.hostName).withStartedDateTime(this.startTime).withTime(this.endTime.getTime() - this.startTime.getTime()).withCache(null).withTimings(null);
        if (!this.port.equals("-1")) {
            builder.withConnection(this.port);
        }
        harWriter.addEntry(builder.build());
        harWriter.closeHar();
    }

    private long calculateHeaderSize(Map<String, List<String>> headers) {
        if (headers == null) {
            return 0L;
        }
        StringBuilder builder = new StringBuilder();
        headers.forEach((key, values) -> {
            for (String value : values) {
                builder.append((String)key).append(": ").append(value).append("\r\n");
            }
        });
        return builder.toString().getBytes().length;
    }
}

