/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.sdk;

import com.smartbear.har.model.HarCreator;
import dev.speakeasyapi.sdk.SpeakeasyHarBuilder;
import dev.speakeasyapi.sdk.client.ISpeakeasyClient;
import java.io.ByteArrayOutputStream;
import java.util.Date;
import org.slf4j.Logger;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class SpeakeasyRequestResponseHandler {
    private final String sdkName = "speakeasy-jvm-sdk";
    private final String speakeasyVersion = "0.0.1";
    private ISpeakeasyClient speakeasyClient;
    private Logger logger;

    public SpeakeasyRequestResponseHandler(ISpeakeasyClient speakeasyClient, Logger logger) {
        this.speakeasyClient = speakeasyClient;
        this.logger = logger;
    }

    public void captureRequestResponse(ContentCachingRequestWrapper request, ContentCachingResponseWrapper response, Date startTime, Date endTime) {
        UriComponents uriComponents = UriComponentsBuilder.fromUriString(request.getRequestURI()).build();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            new SpeakeasyHarBuilder().withStartTime(startTime).withEndTime(endTime).withComment(String.format("request capture for %s", request.getRequestURI())).withCreator(new HarCreator("speakeasy-jvm-sdk", "", "0.0.1")).withHostName(uriComponents.getHost()).withOutputStream(outputStream).withPort(uriComponents.getPort()).withRequest(request).withResponse(response, request.getProtocol()).build();
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.error("speakeasy-sdk: Failed to build Har file:", e);
            } else {
                e.printStackTrace();
            }
            return;
        }
        String harString = new String(outputStream.toByteArray());
        try {
            this.speakeasyClient.ingestGrpc(harString);
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.error("speakeasy-sdk: Failed to ingest request", e);
            }
            e.printStackTrace();
        }
    }
}

