/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.sdk;

import dev.speakeasyapi.sdk.utils.SpeakeasyFilter;
import dev.speakeasyapi.sdk.utils.SpeakeasyInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConfigurationProperties(prefix="speakeasy-api")
@ConfigurationPropertiesScan
@Import(value={SpeakeasyFilter.class})
public class EnableSpeakeasy
implements WebMvcConfigurer {
    private String apiKey;
    private String serverUrl = "grpc.prod.speakeasyapi.dev:443";
    private boolean secureGrpc = true;
    private Logger logger = LoggerFactory.getLogger(EnableSpeakeasy.class);

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setSecureGrpc(boolean secureGrpc) {
        this.secureGrpc = secureGrpc;
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(new SpeakeasyInterceptor(this.apiKey, this.serverUrl, this.secureGrpc, this.logger));
    }
}

