package dev.speakeasyapi.sdk;

import com.smartbear.har.model.HarCreator;
import dev.speakeasyapi.sdk.client.ISpeakeasyClient;
import org.slf4j.Logger;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

import java.io.ByteArrayOutputStream;
import java.util.Date;

public class SpeakeasyRequestResponseHandler {
    private final String sdkName = "speakeasy-jvm-sdk";
    private final String speakeasyVersion = "0.0.1";
    private ISpeakeasyClient speakeasyClient;
    private Logger logger;

    public SpeakeasyRequestResponseHandler(ISpeakeasyClient speakeasyClient, Logger logger) {
        this.speakeasyClient = speakeasyClient;
        this.logger = logger;
    }

    public void captureRequestResponse(ContentCachingRequestWrapper request, ContentCachingResponseWrapper response, Date startTime) {
        UriComponents uriComponents = UriComponentsBuilder
                .fromUriString(request.getRequestURI())
                .build();

        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

        try {
            new SpeakeasyHarBuilder()
                    .withComment(String.format("request capture for %s", uriComponents.getHost()))
                    .withCreator(new HarCreator(sdkName, "", speakeasyVersion))
                    .withHostName(uriComponents.getHost())
                    .withOutputStream(outputStream)
                    .withPort(uriComponents.getPort())
                    .withRequest(request)
                    .withResponse(response)
                    .withStartTime(startTime)
                    .build();
        } catch (Exception e) {
            if (logger != null) {
                logger.error("speakeasy-sdk: Failed to build Har file:", e);
            } else {
                e.printStackTrace();
            }
            return;
        }

        String harString = new String(outputStream.toByteArray());

        try {
            speakeasyClient.ingestGrpc(harString);
        } catch (Exception e) {
            if (logger != null) {
                logger.error("speakeasy-sdk: Failed to ingest request", e);
            } else {
                e.printStackTrace();
            }
        }
    }
}
