package dev.speakeasyapi.sdk.utils;

import dev.speakeasyapi.sdk.SpeakeasyRequestResponseHandler;
import dev.speakeasyapi.sdk.client.SpeakeasyClient;
import org.slf4j.Logger;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;

public class SpeakeasyInterceptor implements HandlerInterceptor {
    private SpeakeasyRequestResponseHandler requestResponseHandler;
    private Date startTime;

    public SpeakeasyInterceptor(String apiKey, String serverUrl, boolean secureGrpc, Logger logger) {
        requestResponseHandler = new SpeakeasyRequestResponseHandler(new SpeakeasyClient(apiKey, serverUrl, secureGrpc), logger);
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        startTime = new Date();
        return true;
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        new Thread(() -> {
            requestResponseHandler.captureRequestResponse((ContentCachingRequestWrapper) request, (ContentCachingResponseWrapper) response, startTime);
        }).start();
    }
}
