/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.sdk.client;

import dev.speakeasyapi.sdk.Ingest;
import dev.speakeasyapi.sdk.IngestServiceGrpc;
import dev.speakeasyapi.sdk.client.ISpeakeasyClient;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.StatusRuntimeException;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.grpc.stub.MetadataUtils;
import javax.net.ssl.SSLException;
import org.springframework.util.StringUtils;

public class SpeakeasyClient
implements ISpeakeasyClient {
    private String authKey = "x-api-key";
    private Metadata.Key<String> metadataKey = Metadata.Key.of(this.authKey, Metadata.ASCII_STRING_MARSHALLER);
    private String apiKey;
    private String serverUrl;
    private boolean secureGrpc;

    public SpeakeasyClient(String apiKey, String serverUrl, boolean secureGrpc) throws IllegalArgumentException {
        if (!StringUtils.hasText(apiKey)) {
            throw new IllegalArgumentException("Speakeasy API key is required.");
        }
        this.apiKey = apiKey;
        this.serverUrl = serverUrl;
        this.secureGrpc = secureGrpc;
    }

    @Override
    public void ingestGrpc(String harString) throws StatusRuntimeException, SSLException {
        Metadata metadata = new Metadata();
        metadata.put(this.metadataKey, this.apiKey);
        Object channelBuilder = this.secureGrpc ? NettyChannelBuilder.forTarget(this.serverUrl).sslContext(GrpcSslContexts.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build()) : ManagedChannelBuilder.forTarget(this.serverUrl).usePlaintext();
        ManagedChannel channel = ((ManagedChannelBuilder)((ManagedChannelBuilder)channelBuilder).intercept(MetadataUtils.newAttachHeadersInterceptor(metadata))).build();
        IngestServiceGrpc.IngestServiceBlockingStub blockingStub = IngestServiceGrpc.newBlockingStub(channel);
        Ingest.IngestRequest ingestRequest = Ingest.IngestRequest.newBuilder().setHar(harString).build();
        try {
            blockingStub.ingest(ingestRequest);
        }
        catch (StatusRuntimeException e) {
            throw e;
        }
        finally {
            channel.shutdown();
        }
    }
}

