/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import javax.servlet.jsp.JspException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.tags.form.AbstractHtmlElementTag;
import org.springframework.web.servlet.tags.form.TagWriter;

public class LabelTag
extends AbstractHtmlElementTag {
    private static final String LABEL_TAG = "label";
    private static final String FOR_ATTRIBUTE = "for";
    @Nullable
    private TagWriter tagWriter;
    @Nullable
    private String forId;

    public void setFor(String forId) {
        this.forId = forId;
    }

    @Nullable
    protected String getFor() {
        return this.forId;
    }

    @Override
    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        tagWriter.startTag(LABEL_TAG);
        tagWriter.writeAttribute(FOR_ATTRIBUTE, this.resolveFor());
        this.writeDefaultAttributes(tagWriter);
        tagWriter.forceBlock();
        this.tagWriter = tagWriter;
        return 1;
    }

    @Override
    @Nullable
    protected String getName() throws JspException {
        return null;
    }

    protected String resolveFor() throws JspException {
        if (StringUtils.hasText(this.forId)) {
            return this.getDisplayString(this.evaluate(FOR_ATTRIBUTE, this.forId));
        }
        return this.autogenerateFor();
    }

    protected String autogenerateFor() throws JspException {
        return StringUtils.deleteAny(this.getPropertyPath(), "[]");
    }

    public int doEndTag() throws JspException {
        Assert.state(this.tagWriter != null, "No TagWriter set");
        this.tagWriter.endTag();
        return 6;
    }

    @Override
    public void doFinally() {
        super.doFinally();
        this.tagWriter = null;
    }
}

