/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.digester;

import java.util.HashMap;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.digester.Rule;
import org.xml.sax.Attributes;

public class SetPropertiesRule
extends Rule {
    protected final HashMap<String, String> excludes;

    public SetPropertiesRule() {
        this.excludes = null;
    }

    public SetPropertiesRule(String[] exclude) {
        this.excludes = new HashMap();
        for (String s2 : exclude) {
            if (s2 == null) continue;
            this.excludes.put(s2, s2);
        }
    }

    @Override
    public void begin(String namespace, String theName, Attributes attributes) throws Exception {
        Object top = this.digester.peek();
        if (this.digester.log.isDebugEnabled()) {
            if (top != null) {
                this.digester.log.debug("[SetPropertiesRule]{" + this.digester.match + "} Set " + top.getClass().getName() + " properties");
            } else {
                this.digester.log.debug("[SetPropertiesRule]{" + this.digester.match + "} Set NULL properties");
            }
        }
        StringBuilder code = this.digester.getGeneratedCode();
        String variableName = null;
        if (code != null) {
            variableName = this.digester.toVariableName(top);
        }
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String name = attributes.getLocalName(i2);
            if (name.isEmpty()) {
                name = attributes.getQName(i2);
            }
            String value = attributes.getValue(i2);
            if (this.digester.log.isDebugEnabled()) {
                this.digester.log.debug("[SetPropertiesRule]{" + this.digester.match + "} Setting property '" + name + "' to '" + value + "'");
            }
            if (this.digester.isFakeAttribute(top, name) || this.excludes != null && this.excludes.containsKey(name)) continue;
            StringBuilder actualMethod = null;
            if (code != null) {
                actualMethod = new StringBuilder();
            }
            if (!IntrospectionUtils.setProperty(top, name, value, true, actualMethod)) {
                if (!this.digester.getRulesValidation() || "optional".equals(name)) continue;
                this.digester.log.warn(sm.getString("rule.noProperty", this.digester.match, name, value));
                continue;
            }
            if (code == null) continue;
            code.append(variableName).append(".").append((CharSequence)actualMethod).append(';');
            code.append(System.lineSeparator());
        }
        if (top instanceof Listener) {
            ((Listener)top).endSetPropertiesRule();
            if (code != null) {
                code.append("((org.apache.tomcat.util.digester.SetPropertiesRule.Listener) ");
                code.append(variableName).append(").endSetPropertiesRule();");
                code.append(System.lineSeparator());
            }
        }
    }

    public String toString() {
        return "SetPropertiesRule[]";
    }

    public static interface Listener {
        public void endSetPropertiesRule();
    }
}

