/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.springboot;

import dev.speakeasyapi.sdk.SpeakeasyCookie;
import dev.speakeasyapi.sdk.SpeakeasyResponse;
import dev.speakeasyapi.sdk.utils.Utils;
import dev.speakeasyapi.springboot.RequestResponseCaptureWatcher;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.ByteArrayOutputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;

public class SpeakeasyServletResponse
implements SpeakeasyResponse {
    private final HttpServletResponse response;
    private final RequestResponseCaptureWatcher watcher;

    public SpeakeasyServletResponse(HttpServletResponse response, RequestResponseCaptureWatcher watcher) {
        this.response = response;
        this.watcher = watcher;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.response.getHeaderNames().stream().collect(Collectors.toMap(h2 -> h2.toLowerCase(), h2 -> new ArrayList(this.response.getHeaders(h2)), Utils.merge));
    }

    @Override
    public List<SpeakeasyCookie> getCookies(Instant startTime) {
        List<String> cookieHeaders;
        Map<String, List<String>> headers = this.getHeaders();
        if (headers != null && (cookieHeaders = headers.get(HttpHeaderNames.SET_COOKIE.toString())) != null) {
            return cookieHeaders.stream().map(cookieHeader -> Utils.parseSetCookieString(cookieHeader, startTime)).collect(Collectors.toList());
        }
        return new ArrayList<SpeakeasyCookie>();
    }

    @Override
    public String getContentType() {
        return this.response.getContentType();
    }

    @Override
    public String getBodyText(String droppedText) {
        if (this.watcher.getResponseIsValid()) {
            ByteArrayOutputStream responseCache = this.watcher.getResponseCache();
            try {
                responseCache.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return responseCache.toString();
        }
        return droppedText;
    }

    @Override
    public Long getContentLength(boolean originalSize) {
        long size;
        if ((this.watcher.getResponseIsValid() || originalSize) && (size = this.watcher.getRealResponseBodySize()) > 0L) {
            return size;
        }
        return -1L;
    }

    @Override
    public int getStatus() {
        return this.response.getStatus();
    }

    @Override
    public String getLocationHeader() {
        return this.response.getHeader("Location");
    }

    @Override
    public Long getHeaderSize() {
        return Utils.calculateHeaderSize(this.getHeaders());
    }
}

