/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.springboot;

import com.google.common.util.concurrent.MoreExecutors;
import dev.speakeasyapi.sdk.SpeakeasyConfig;
import dev.speakeasyapi.sdk.SpeakeasyMiddlewareController;
import dev.speakeasyapi.sdk.client.ISpeakeasyClient;
import dev.speakeasyapi.sdk.client.SpeakeasyClient;
import dev.speakeasyapi.springboot.RequestResponseCaptureWatcher;
import dev.speakeasyapi.springboot.SpeakeasyRequestResponseHandler;
import dev.speakeasyapi.springboot.SpeakeasyRequestWrapper;
import java.time.Instant;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class SpeakeasyInterceptor
implements HandlerInterceptor {
    public static final String StartTimeKey = "speakeasyStartTime";
    private Executor pool;
    private final ISpeakeasyClient client;
    private Logger logger = LoggerFactory.getLogger(SpeakeasyInterceptor.class);

    public SpeakeasyInterceptor(SpeakeasyConfig cfg) {
        this(cfg, null);
    }

    public SpeakeasyInterceptor(SpeakeasyConfig cfg, ISpeakeasyClient client) {
        this.pool = Executors.newCachedThreadPool();
        if (!cfg.isIngestEnabled()) {
            this.pool = MoreExecutors.directExecutor();
        }
        this.client = client != null ? client : new SpeakeasyClient(cfg);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        request.setAttribute("speakeasyMiddlewareController", (Object)new SpeakeasyMiddlewareController(this.client));
        request.setAttribute(StartTimeKey, (Object)Instant.now());
        return true;
    }

    public void afterCompletion(HttpServletRequest req, HttpServletResponse res, Object handler, Exception ex) {
        SpeakeasyMiddlewareController controller = (SpeakeasyMiddlewareController)req.getAttribute("speakeasyMiddlewareController");
        String pathHint = StringUtils.hasText((String)controller.getPathHint()) ? controller.getPathHint() : SpeakeasyInterceptor.getPathHint((HandlerMethod)handler);
        Instant startTime = (Instant)req.getAttribute(StartTimeKey);
        RequestResponseCaptureWatcher watcher = (RequestResponseCaptureWatcher)req.getAttribute(SpeakeasyRequestWrapper.speakeasyRequestResponseWatcherAttribute);
        this.pool.execute(new SpeakeasyRequestResponseHandler(this.client, this.logger, req, res, watcher, controller.getMasking(), startTime, Instant.now(), pathHint, controller.getCustomerID()));
    }

    private static String getPathHint(HandlerMethod hm) {
        PatchMapping mapping;
        RequestMapping ctrlMapping;
        String controllerPath = "";
        String pathHint = "";
        if (hm.getBean().getClass().isAnnotationPresent(RequestMapping.class) && (ctrlMapping = hm.getBean().getClass().getAnnotation(RequestMapping.class)) != null && ctrlMapping.value() != null && ctrlMapping.value().length > 0) {
            controllerPath = ctrlMapping.value()[0];
            if (pathHint.endsWith("/")) {
                controllerPath = pathHint.substring(0, pathHint.length() - 1);
            }
            if (!controllerPath.startsWith("/")) {
                controllerPath = "/" + controllerPath;
            }
        }
        String methodPath = "";
        if (hm.hasMethodAnnotation(RequestMapping.class)) {
            RequestMapping mapping2 = (RequestMapping)hm.getMethodAnnotation(RequestMapping.class);
            if (mapping2 != null && mapping2.value() != null && mapping2.value().length > 0) {
                methodPath = mapping2.value()[0];
            }
        } else if (hm.hasMethodAnnotation(GetMapping.class)) {
            GetMapping mapping3 = (GetMapping)hm.getMethodAnnotation(GetMapping.class);
            if (mapping3 != null && mapping3.value() != null && mapping3.value().length > 0) {
                methodPath = mapping3.value()[0];
            }
        } else if (hm.hasMethodAnnotation(PostMapping.class)) {
            PostMapping mapping4 = (PostMapping)hm.getMethodAnnotation(PostMapping.class);
            if (mapping4 != null && mapping4.value() != null && mapping4.value().length > 0) {
                methodPath = mapping4.value()[0];
            }
        } else if (hm.hasMethodAnnotation(PutMapping.class)) {
            PutMapping mapping5 = (PutMapping)hm.getMethodAnnotation(PutMapping.class);
            if (mapping5 != null && mapping5.value() != null && mapping5.value().length > 0) {
                methodPath = mapping5.value()[0];
            }
        } else if (hm.hasMethodAnnotation(DeleteMapping.class)) {
            DeleteMapping mapping6 = (DeleteMapping)hm.getMethodAnnotation(DeleteMapping.class);
            if (mapping6 != null && mapping6.value() != null && mapping6.value().length > 0) {
                methodPath = mapping6.value()[0];
            }
        } else if (hm.hasMethodAnnotation(PatchMapping.class) && (mapping = (PatchMapping)hm.getMethodAnnotation(PatchMapping.class)) != null && mapping.value() != null && mapping.value().length > 0) {
            methodPath = mapping.value()[0];
        }
        if (!methodPath.startsWith("/")) {
            methodPath = "/" + methodPath;
        }
        return controllerPath + methodPath;
    }
}

