/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.springboot;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;

public class RequestResponseCaptureWatcher {
    private final long defaultMaxCaptureSize = 0x100000L;
    private long maxCaptureSize;
    private boolean requestIsValid = true;
    private ByteArrayOutputStream requestCache = new ByteArrayOutputStream();
    private boolean responseIsValid = true;
    private long realResponseBodySize = 0L;
    private ServletOutputStream responseOutputStream;
    private ByteArrayOutputStream responseCache = new ByteArrayOutputStream();

    public RequestResponseCaptureWatcher() {
        this.maxCaptureSize = 0x100000L;
    }

    public RequestResponseCaptureWatcher(long maxCaptureSize) {
        this.maxCaptureSize = maxCaptureSize;
    }

    public boolean getRequestIsValid() {
        return (long)this.requestCache.size() <= this.maxCaptureSize;
    }

    public void withServletRequest(HttpServletRequest request) {
        try {
            IOUtils.copy((InputStream)request.getInputStream(), (OutputStream)this.requestCache);
        }
        catch (IOException e) {
            this.requestCache = new ByteArrayOutputStream();
        }
    }

    public ServletInputStream getCopiedInputStream() {
        final ByteArrayInputStream wrappedInputStream = new ByteArrayInputStream(this.requestCache.toByteArray());
        return new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener listener) {
            }

            public int read() throws IOException {
                return wrappedInputStream.read();
            }
        };
    }

    public ByteArrayOutputStream getRequestCache() {
        return this.requestCache;
    }

    public boolean getResponseIsValid() {
        return this.responseIsValid;
    }

    public long getRealResponseBodySize() {
        return this.realResponseBodySize;
    }

    public RequestResponseCaptureWatcher withResponseOutputStream(ServletOutputStream outputStream) {
        this.responseOutputStream = outputStream;
        return this;
    }

    public ByteArrayOutputStream getResponseCache() {
        return this.responseCache;
    }

    private boolean canWriteResponseCache() {
        boolean canCache = this.cacheSizeExceedsMaxCaptureSize();
        if (!canCache && this.responseIsValid) {
            this.responseIsValid = false;
        }
        return canCache;
    }

    public void writeResponse(int b) throws IOException {
        this.responseOutputStream.write(b);
        ++this.realResponseBodySize;
        if (this.canWriteResponseCache()) {
            this.responseCache.write(b);
        }
    }

    private boolean cacheSizeExceedsMaxCaptureSize() {
        return this.requestIsValid && this.responseIsValid && (long)(1 + this.requestCache.size() + this.responseCache.size()) <= this.maxCaptureSize;
    }
}

