/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.springboot;

import dev.speakeasyapi.sdk.SpeakeasyConfig;
import dev.speakeasyapi.springboot.SpeakeasyFilter;
import dev.speakeasyapi.springboot.SpeakeasyInterceptor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConfigurationProperties(prefix="speakeasy-api")
@ConfigurationPropertiesScan
@Import(value={SpeakeasyFilter.class})
public class EnableSpeakeasy
implements WebMvcConfigurer {
    private SpeakeasyConfig cfg = new SpeakeasyConfig();

    public void setApiKey(String apiKey) {
        this.cfg.setApiKey(apiKey);
    }

    public void setApiID(String apiID) {
        this.cfg.setApiID(apiID);
    }

    public void setVersionID(String versionID) {
        this.cfg.setVersionID(versionID);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new SpeakeasyInterceptor(this.cfg));
    }
}

