/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.sdk.client;

import dev.speakeasyapi.accesstokens.EmbedAccessTokenServiceGrpc;
import dev.speakeasyapi.accesstokens.Embedaccesstoken;
import dev.speakeasyapi.schemas.Ingest;
import dev.speakeasyapi.schemas.IngestServiceGrpc;
import dev.speakeasyapi.sdk.SpeakeasyConfig;
import dev.speakeasyapi.sdk.client.ISpeakeasyClient;
import dev.speakeasyapi.sdk.masking.Masking;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.MetadataUtils;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;

public class SpeakeasyClient
implements ISpeakeasyClient {
    private final String authKey = "x-api-key";
    private final Metadata.Key<String> metadataKey = Metadata.Key.of("x-api-key", Metadata.ASCII_STRING_MARSHALLER);
    private final SpeakeasyConfig cfg;

    public SpeakeasyClient(SpeakeasyConfig cfg) throws IllegalArgumentException {
        cfg.validate();
        this.cfg = cfg;
    }

    @Override
    public void ingestGrpc(String harString, String pathHint, String customerID, Masking masking) throws RuntimeException {
        if (!this.cfg.isIngestEnabled()) {
            return;
        }
        ManagedChannel channel = null;
        try {
            channel = this.createChannel();
        }
        catch (SSLException e) {
            throw new RuntimeException("Failed to create channel", e);
        }
        try {
            IngestServiceGrpc.IngestServiceBlockingStub blockingStub = IngestServiceGrpc.newBlockingStub(channel);
            Ingest.IngestRequest.MaskingMetadata maskingMetadata = Ingest.IngestRequest.MaskingMetadata.newBuilder().putAllQueryStringMasks(masking.getQueryStringMasks()).putAllRequestHeaderMasks(masking.getRequestHeaderMasks()).putAllResponseHeaderMasks(masking.getResponseHeaderMasks()).putAllRequestCookieMasks(masking.getRequestCookieMasks()).putAllResponseCookieMasks(masking.getResponseCookieMasks()).putAllRequestFieldMasksString(masking.getRequestBodyMasksString()).putAllRequestFieldMasksNumber(masking.getRequestBodyMasksNumber()).putAllResponseFieldMasksString(masking.getResponseBodyMasksString()).putAllResponseFieldMasksNumber(masking.getResponseBodyMasksNumber()).build();
            Ingest.IngestRequest.Builder ingestRequestBuilder = Ingest.IngestRequest.newBuilder().setHar(harString).setApiId(this.cfg.getApiID()).setVersionId(this.cfg.getVersionID()).setMaskingMetadata(maskingMetadata).setPathHint(pathHint);
            if (customerID != null) {
                ingestRequestBuilder.setCustomerId(customerID);
            }
            Ingest.IngestRequest ingestRequest = ingestRequestBuilder.build();
            blockingStub.ingest(ingestRequest);
            channel.shutdown();
            channel.awaitTermination(100L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            channel.shutdown();
            throw new RuntimeException(e);
        }
    }

    @Override
    public Embedaccesstoken.EmbedAccessTokenResponse getEmbedAccessToken(Embedaccesstoken.EmbedAccessTokenRequest request) throws RuntimeException {
        ManagedChannel channel;
        try {
            channel = this.createChannel();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        EmbedAccessTokenServiceGrpc.EmbedAccessTokenServiceBlockingStub blockingStub = EmbedAccessTokenServiceGrpc.newBlockingStub(channel);
        return blockingStub.get(request);
    }

    private ManagedChannel createChannel() throws SSLException {
        Metadata metadata = new Metadata();
        metadata.put(this.metadataKey, this.cfg.getApiKey());
        String serverUrl = this.cfg.getServerUrl();
        Object channelBuilder = this.cfg.isSecureGrpc() ? NettyChannelBuilder.forTarget(serverUrl).sslContext(GrpcSslContexts.forClient().build()) : ManagedChannelBuilder.forTarget(serverUrl).usePlaintext();
        return ((ManagedChannelBuilder)((ManagedChannelBuilder)channelBuilder).intercept(MetadataUtils.newAttachHeadersInterceptor(metadata))).build();
    }
}

