/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.sdk;

import com.smartbear.har.builder.HarContentBuilder;
import com.smartbear.har.builder.HarCookieBuilder;
import com.smartbear.har.builder.HarEntryBuilder;
import com.smartbear.har.builder.HarHeaderBuilder;
import com.smartbear.har.builder.HarPostDataBuilder;
import com.smartbear.har.builder.HarRequestBuilder;
import com.smartbear.har.builder.HarResponseBuilder;
import com.smartbear.har.creator.DefaultHarStreamWriter;
import com.smartbear.har.model.HarCache;
import com.smartbear.har.model.HarCookie;
import com.smartbear.har.model.HarCreator;
import com.smartbear.har.model.HarHeader;
import com.smartbear.har.model.HarPostData;
import com.smartbear.har.model.HarRequest;
import com.smartbear.har.model.HarResponse;
import com.smartbear.har.model.HarTimings;
import dev.speakeasyapi.sdk.SpeakeasyCookie;
import dev.speakeasyapi.sdk.SpeakeasyRequest;
import dev.speakeasyapi.sdk.SpeakeasyResponse;
import dev.speakeasyapi.sdk.masking.Masking;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.slf4j.Logger;

public class SpeakeasyHarBuilder {
    private final String sdkName = "speakeasy-java-sdk";
    private final String speakeasyVersion = "1.3.1";
    private final String droppedBodyText = "--dropped--";
    private final DefaultHarStreamWriter.Builder harWriterBuilder;
    private final Logger logger;
    private Masking masking = null;
    private OutputStream outputStream;
    private Instant startTime = Instant.now();
    private Instant endTime = Instant.now();
    private String hostName;
    private String port;
    private HarRequest harRequest;
    private HarResponse harResponse;
    private SpeakeasyRequest request = null;

    public SpeakeasyHarBuilder(Logger logger) {
        this.harWriterBuilder = new DefaultHarStreamWriter.Builder();
        this.logger = logger;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getPort() {
        return this.port;
    }

    public HarRequest getHarRequest() {
        return this.harRequest;
    }

    public HarResponse getHarResponse() {
        return this.harResponse;
    }

    public SpeakeasyHarBuilder withStartTime(Instant startTime) {
        this.startTime = startTime;
        return this;
    }

    public SpeakeasyHarBuilder withEndTime(Instant endTime) {
        this.endTime = endTime;
        return this;
    }

    public SpeakeasyHarBuilder withMasking(Masking masking) {
        this.masking = masking;
        return this;
    }

    public SpeakeasyHarBuilder withRequest(SpeakeasyRequest request) throws IOException {
        this.request = request;
        ArrayList<HarCookie> harCookieList = new ArrayList();
        List<SpeakeasyCookie> cookies = request.getCookies();
        if (cookies != null) {
            harCookieList = cookies.stream().map(c -> {
                HarCookieBuilder cookieBuilder = new HarCookieBuilder();
                try {
                    String mask;
                    String name = c.getName();
                    String value = c.getValue();
                    if (this.masking != null && (mask = this.masking.getRequestCookieMasks().get(name)) != null) {
                        value = mask;
                    }
                    cookieBuilder.withName(name).withValue(value);
                }
                catch (Exception e) {
                    this.logger.debug("speakeasy-sdk, error building cookies:", e);
                }
                return cookieBuilder.build();
            }).collect(Collectors.toList());
        }
        List<Object> harHeaderList = new ArrayList();
        Map<String, List<String>> headers = request.getHeaders();
        if (headers != null) {
            harHeaderList = headers.entrySet().stream().map(entry -> {
                ArrayList<HarHeader> headersList = new ArrayList<HarHeader>();
                for (String value : (List)entry.getValue()) {
                    String mask;
                    String name = (String)entry.getKey();
                    if (this.masking != null && (mask = this.masking.getRequestHeaderMasks().get(name)) != null) {
                        value = mask;
                    }
                    headersList.add(new HarHeaderBuilder().withName(name).withValue(value).build());
                }
                return headersList;
            }).flatMap(list -> list.stream()).collect(Collectors.toList());
            harHeaderList.sort((h1, h2) -> h1.getName().compareToIgnoreCase(h2.getName()));
        }
        String body = request.getBodyText("--dropped--");
        if (this.masking != null) {
            body = this.masking.maskRequestBody(body, request.getContentType());
        }
        HarPostDataBuilder postDataBuilder = new HarPostDataBuilder().withMimeType(request.getContentType()).withText(body);
        HarPostData postData = postDataBuilder.build();
        String url = this.resolveURL(request);
        HarRequestBuilder builder = new HarRequestBuilder().withBodySize(request.getContentLength()).withCookies(harCookieList).withHeaders(harHeaderList).withHeadersSize(request.getHeaderSize()).withHttpVersion(request.getProtocol()).withMethod(request.getMethod()).withQueryString(this.getMaskedQueryString(request.getQueryString())).withUrl(url);
        if (request.getContentLength() > 0L) {
            builder.withPostData(postData);
        }
        this.harRequest = builder.build();
        return this;
    }

    public SpeakeasyHarBuilder withResponse(SpeakeasyResponse response, String httpVersion) {
        String contentType;
        if (response == null) {
            return this;
        }
        List<HarHeader> harHeaderList = null;
        Map<String, List<String>> headers = response.getHeaders();
        if (headers != null) {
            harHeaderList = headers.entrySet().stream().map(entry -> {
                ArrayList<HarHeader> headersList = new ArrayList<HarHeader>();
                for (String value : (List)entry.getValue()) {
                    String mask;
                    String name = (String)entry.getKey();
                    if (this.masking != null && (mask = this.masking.getResponseHeaderMasks().get(name)) != null) {
                        value = mask;
                    }
                    headersList.add(new HarHeaderBuilder().withName(name).withValue(value).build());
                }
                return headersList;
            }).flatMap(list -> list.stream()).collect(Collectors.toList());
            harHeaderList.sort((h1, h2) -> h1.getName().compareToIgnoreCase(h2.getName()));
        }
        List<SpeakeasyCookie> cookies = response.getCookies(this.startTime);
        List<HarCookie> harCookieList = null;
        if (cookies != null) {
            harCookieList = cookies.stream().map(c -> {
                HarCookieBuilder cookieBuilder = new HarCookieBuilder();
                try {
                    String mask;
                    String name = c.getName();
                    String value = c.getValue();
                    if (this.masking != null && (mask = this.masking.getResponseCookieMasks().get(name)) != null) {
                        value = mask;
                    }
                    cookieBuilder.withName(name).withValue(value).withExpires(c.getExpires()).withHttpOnly(c.getHttpOnly()).withPath(c.getPath()).withSecure(c.getSecure()).withDomain(c.getDomain());
                }
                catch (Exception e) {
                    this.logger.debug("speakeasy-sdk, error building cookies:", e);
                }
                return cookieBuilder.build();
            }).collect(Collectors.toList());
        }
        if (StringUtils.isBlank(contentType = response.getContentType())) {
            contentType = "application/octet-stream";
        }
        HarContentBuilder harContentBuilder = new HarContentBuilder().withSize(response.getContentLength(false)).withMimeType(contentType);
        long bodySize = response.getContentLength(true);
        if (response.getStatus() == 304) {
            bodySize = 0L;
            harContentBuilder.withSize(-1L);
        } else {
            String body = response.getBodyText("--dropped--");
            if (this.masking != null) {
                body = this.masking.maskResponseBody(body, contentType);
            }
            harContentBuilder.withText(body);
        }
        String redirectURL = response.getLocationHeader();
        int statusCode = response.getStatus();
        String statusText = null;
        try {
            statusText = EnglishReasonPhraseCatalog.INSTANCE.getReason(statusCode, null);
        }
        catch (Exception e) {
            this.logger.debug("speakeasy-sdk, error retrieving status: ", e);
        }
        this.harResponse = new HarResponseBuilder().withStatus(statusCode).withStatusText(statusText).withCookies(harCookieList).withContent(harContentBuilder.build()).withBodySize(bodySize).withHeaders(harHeaderList).withHeadersSize(response.getHeaderSize()).withHttpVersion(httpVersion).withRedirectURL(redirectURL).build();
        return this;
    }

    public SpeakeasyHarBuilder withOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        return this;
    }

    public void build() throws IOException {
        DefaultHarStreamWriter harWriter = this.harWriterBuilder.withOutputStream(this.outputStream).withComment(String.format("request capture for %s", this.resolveURL(this.request))).withCreator(new HarCreator(this.sdkName, "", this.speakeasyVersion)).build();
        HarEntryBuilder builder = new HarEntryBuilder().withRequest(this.harRequest).withResponse(this.harResponse).withServerIPAddress(this.hostName).withStartedDateTime(this.startTime).withTime(this.endTime.toEpochMilli() - this.startTime.toEpochMilli()).withCache(new HarCache()).withTimings(new HarTimings(0L, 0L, 0L, -1L, -1L, -1L, 0L, ""));
        if (this.port != null && !this.port.equals("-1")) {
            builder.withConnection(this.port);
        }
        harWriter.addEntry(builder.build());
        harWriter.closeHar();
    }

    private String resolveURL(SpeakeasyRequest request) {
        List<String> headers;
        String uri = request.getRequestURI();
        String scheme = "";
        String host = "";
        int port = -1;
        String path = uri;
        String queryString = "";
        String ref = "";
        try {
            URL url = new URL(uri);
            scheme = url.getProtocol();
            host = url.getHost();
            port = url.getPort();
            path = url.getPath();
            queryString = url.getQuery();
            ref = url.getRef();
        }
        catch (MalformedURLException url) {
            // empty catch block
        }
        String proxyScheme = this.getScheme(request);
        if (StringUtils.isNotBlank(proxyScheme)) {
            scheme = proxyScheme;
        }
        if (request.getHeaders().containsKey("x-forwarded-host")) {
            headers = request.getHeaders().get("x-forwarded-host");
            if (headers != null && headers.size() > 0) {
                host = headers.get(0);
            }
        } else if (request.getHeaders().containsKey("host") && (headers = request.getHeaders().get("host")) != null && headers.size() > 0) {
            host = headers.get(0);
        }
        this.hostName = host;
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotBlank(scheme)) {
            builder.append(scheme);
            builder.append("://");
        }
        if (StringUtils.isNotBlank(host)) {
            String[] parts;
            builder.append(host);
            if (port == -1 && (parts = host.split(":")).length > 1) {
                try {
                    port = Integer.parseInt(parts[1]);
                }
                catch (Exception e) {
                    port = -1;
                }
            }
            if (!host.contains(":") && port != -1 && port != 80 && port != 443) {
                builder.append(":").append(port);
            }
        }
        this.port = String.valueOf(port);
        builder.append(path);
        if (StringUtils.isNotBlank(queryString)) {
            builder.append("?").append(this.getMaskedQueryString(queryString));
        }
        if (StringUtils.isNotBlank(ref)) {
            builder.append("#").append(ref);
        }
        return builder.toString();
    }

    private String getScheme(SpeakeasyRequest request) {
        String scheme = "";
        if (request.getHeaders().containsKey("x-forwarded-proto")) {
            List<String> headers = request.getHeaders().get("x-forwarded-proto");
            if (headers != null && headers.size() > 0) {
                scheme = headers.get(0).toLowerCase();
            }
        } else if (request.getHeaders().containsKey("x-forwarded-scheme")) {
            List<String> headers = request.getHeaders().get("x-forwarded-scheme");
            if (headers != null && headers.size() > 0) {
                scheme = headers.get(0);
            }
        } else if (request.getHeaders().containsKey("forwarded")) {
            Pattern pattern;
            Matcher matcher;
            List<String> headers = request.getHeaders().get("forwarded");
            String forwarded = "";
            if (headers != null && headers.size() > 0) {
                forwarded = headers.get(0).toLowerCase();
            }
            if (forwarded != "" && (matcher = (pattern = Pattern.compile("(?i)(?:proto=)(https|http)", 2)).matcher(forwarded)).find()) {
                scheme = matcher.group(1).toLowerCase();
            }
        }
        return scheme;
    }

    private String getMaskedQueryString(String queryString) {
        if (queryString == null) {
            return "";
        }
        String[] params = queryString.split("&");
        ArrayList<String> maskedParams = new ArrayList<String>();
        for (String param : params) {
            try {
                String[] keyValuePair = param.split("=");
                if (keyValuePair.length == 2) {
                    String maskedValue;
                    String key = URLDecoder.decode(keyValuePair[0], "UTF-8");
                    String value = URLDecoder.decode(keyValuePair[1], "UTF-8");
                    if (this.masking != null && (maskedValue = this.masking.getQueryStringMasks().get(key)) != null) {
                        value = maskedValue;
                    }
                    maskedParams.add(URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8"));
                    continue;
                }
                maskedParams.add(param);
            }
            catch (UnsupportedEncodingException e) {
                maskedParams.add(param);
            }
        }
        return String.join((CharSequence)"&", maskedParams);
    }
}

