/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.micronaut.implementation;

import dev.speakeasyapi.micronaut.implementation.SpeakeasyCaptureWriter;
import dev.speakeasyapi.sdk.SpeakeasyCookie;
import dev.speakeasyapi.sdk.SpeakeasyResponse;
import dev.speakeasyapi.sdk.utils.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SpeakeasyNettyResponse
implements SpeakeasyResponse {
    private final HttpResponse response;
    private SpeakeasyCaptureWriter writer;

    public SpeakeasyNettyResponse(HttpResponse response) {
        this.response = response;
    }

    public void register(SpeakeasyCaptureWriter writer) {
        this.writer = writer;
    }

    public void buffer(ByteBuf content) {
        this.writer.writeResponse(content);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        if (this.response.headers() != null) {
            return this.response.headers().entries().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).toLowerCase(), e -> Collections.singletonList((String)e.getValue())));
        }
        return null;
    }

    @Override
    public List<SpeakeasyCookie> getCookies(Instant startTime) {
        List<String> cookieHeaders;
        if (this.response.headers() != null && (cookieHeaders = this.response.headers().getAll(HttpHeaderNames.SET_COOKIE)) != null) {
            return cookieHeaders.stream().map(cookieHeader -> Utils.parseSetCookieString(cookieHeader, startTime)).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public String getContentType() {
        if (this.response.headers() != null) {
            return this.response.headers().get(HttpHeaderNames.CONTENT_TYPE);
        }
        return null;
    }

    @Override
    public String getBodyText(String droppedText) {
        if (this.writer.isResValid()) {
            return new String(this.writer.getResBuffer());
        }
        return droppedText;
    }

    @Override
    public Long getContentLength(boolean originalSize) {
        long size;
        if ((this.writer.isResValid() || originalSize) && (size = HttpUtil.getContentLength((HttpMessage)this.response, -1L)) > 0L) {
            return size;
        }
        return -1L;
    }

    @Override
    public int getStatus() {
        return this.response.status().code();
    }

    @Override
    public String getLocationHeader() {
        if (this.response.headers() != null) {
            return this.response.headers().get(HttpHeaderNames.LOCATION);
        }
        return null;
    }

    @Override
    public Long getHeaderSize() {
        return Utils.calculateHeaderSize(this.getHeaders());
    }
}

