/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.micronaut.implementation;

import dev.speakeasyapi.micronaut.implementation.SpeakeasyCaptureWriter;
import dev.speakeasyapi.micronaut.implementation.SpeakeasySingleton;
import dev.speakeasyapi.sdk.SpeakeasyCookie;
import dev.speakeasyapi.sdk.SpeakeasyRequest;
import dev.speakeasyapi.sdk.utils.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class SpeakeasyNettyRequest
implements SpeakeasyRequest {
    private final HttpRequest request;
    private SpeakeasyCaptureWriter writer;
    private final String requestId;

    public SpeakeasyNettyRequest(HttpRequest request) {
        this.request = request;
        this.requestId = UUID.randomUUID().toString();
        SpeakeasySingleton.getInstance().registerRequest(this.requestId);
        this.request.headers().add("X-Speakeasy-Request-Id", (Object)this.requestId);
    }

    public void register(SpeakeasyCaptureWriter writer) {
        this.writer = writer;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void removeRequestId() {
        this.request.headers().remove("X-Speakeasy-Request-Id");
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public void buffer(ByteBuf content) {
        this.writer.writeRequest(content);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        if (this.request.headers() != null) {
            return this.request.headers().entries().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).toLowerCase(), e -> Collections.singletonList((String)e.getValue()), Utils.merge));
        }
        return null;
    }

    @Override
    public List<SpeakeasyCookie> getCookies() {
        List<String> cookieHeaders;
        if (this.request.headers() != null && (cookieHeaders = this.request.headers().getAll(HttpHeaderNames.COOKIE)) != null) {
            return cookieHeaders.stream().map(cookieHeader -> {
                Set<Cookie> cookies = ServerCookieDecoder.STRICT.decode((String)cookieHeader);
                return cookies.stream().map(cookie -> new SpeakeasyCookie(cookie.name(), cookie.value()));
            }).flatMap(cookie -> cookie).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public String getContentType() {
        if (this.request.headers() != null) {
            return this.request.headers().get(HttpHeaderNames.CONTENT_TYPE);
        }
        return null;
    }

    @Override
    public String getBodyText(String droppedText) {
        if (this.writer.isReqValid()) {
            return new String(this.writer.getReqBuffer());
        }
        return droppedText;
    }

    @Override
    public String getQueryString() {
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.request.uri());
        return queryStringDecoder.rawQuery();
    }

    @Override
    public Long getContentLength() {
        return HttpUtil.getContentLength((HttpMessage)this.request, 0L);
    }

    @Override
    public Long getHeaderSize() {
        return Utils.calculateHeaderSize(this.getHeaders());
    }

    @Override
    public String getProtocol() {
        return this.request.protocolVersion().text();
    }

    @Override
    public String getMethod() {
        return this.request.method().name();
    }

    @Override
    public String getRequestURI() {
        return this.request.uri();
    }
}

