/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.micronaut;

import dev.speakeasyapi.micronaut.implementation.SpeakeasyRequestContext;
import dev.speakeasyapi.micronaut.implementation.SpeakeasySingleton;
import dev.speakeasyapi.sdk.SpeakeasyMiddlewareController;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import org.apache.commons.lang3.StringUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Filter(value={"/**"})
public class SpeakeasyFilter
implements HttpServerFilter {
    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        return Flux.from(Mono.fromCallable(() -> {
            SpeakeasyRequestContext context;
            String requestId = (String)request.getHeaders().get((CharSequence)"X-Speakeasy-Request-Id");
            if (StringUtils.isNotEmpty(requestId) && (context = SpeakeasySingleton.getInstance().getRequestContext(requestId)) != null) {
                SpeakeasyMiddlewareController ctrl = context.getController();
                request.setAttribute((CharSequence)"speakeasyMiddlewareController", (Object)ctrl);
            }
            return true;
        }).subscribeOn(Schedulers.boundedElastic()).flux()).switchMap(aBoolean -> chain.proceed(request)).doOnNext(res -> {});
    }
}

