/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.springboot;

import dev.speakeasyapi.sdk.SpeakeasyCookie;
import dev.speakeasyapi.sdk.SpeakeasyRequest;
import dev.speakeasyapi.sdk.utils.Utils;
import dev.speakeasyapi.springboot.RequestResponseCaptureWatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class SpeakeasyServletRequest
implements SpeakeasyRequest {
    private final HttpServletRequest request;
    private final RequestResponseCaptureWatcher watcher;

    public SpeakeasyServletRequest(HttpServletRequest request, RequestResponseCaptureWatcher watcher) {
        this.request = request;
        this.watcher = watcher;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        if (this.request.getHeaderNames() != null) {
            return Collections.list(this.request.getHeaderNames()).stream().collect(Collectors.toMap(h2 -> h2.toLowerCase(), h2 -> Collections.list(this.request.getHeaders(h2)), Utils.merge));
        }
        return null;
    }

    @Override
    public List<SpeakeasyCookie> getCookies() {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            return Arrays.asList(cookies).stream().map(c -> new SpeakeasyCookie(c.getName(), c.getValue())).collect(Collectors.toList());
        }
        return new ArrayList<SpeakeasyCookie>();
    }

    @Override
    public String getContentType() {
        return this.request.getContentType();
    }

    @Override
    public String getBodyText(String droppedText) {
        if (this.watcher.getRequestIsValid()) {
            return this.watcher.getRequestCache().toString();
        }
        return droppedText;
    }

    @Override
    public String getQueryString() {
        return this.request.getQueryString();
    }

    @Override
    public Long getContentLength() {
        return this.request.getContentLengthLong();
    }

    @Override
    public Long getHeaderSize() {
        return Utils.calculateHeaderSize(this.getHeaders());
    }

    @Override
    public String getProtocol() {
        return this.request.getProtocol();
    }

    @Override
    public String getMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getRequestURI() {
        return this.request.getRequestURI();
    }
}

