/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.springboot;

import dev.speakeasyapi.springboot.RequestResponseCaptureWatcher;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class SpeakeasyResponseWrapper
implements HttpServletResponse {
    private HttpServletResponse wrapped;
    private OutputStreamWrapper outputStreamWrapper;

    public SpeakeasyResponseWrapper(HttpServletResponse wrapped, RequestResponseCaptureWatcher watcher) throws IOException {
        this.outputStreamWrapper = new OutputStreamWrapper(wrapped.getOutputStream(), watcher);
        this.wrapped = wrapped;
    }

    public long getRealBodySize() {
        return this.outputStreamWrapper.watcher.getRealResponseBodySize();
    }

    public void addCookie(Cookie cookie) {
        this.wrapped.addCookie(cookie);
    }

    public boolean containsHeader(String name) {
        return this.wrapped.containsHeader(name);
    }

    public String encodeURL(String url) {
        return this.wrapped.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        return this.wrapped.encodeRedirectURL(url);
    }

    public String encodeUrl(String url) {
        return this.wrapped.encodeURL(url);
    }

    @Deprecated
    public String encodeRedirectUrl(String url) {
        return this.wrapped.encodeRedirectUrl(url);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.wrapped.sendError(sc, msg);
    }

    public void sendError(int sc) throws IOException {
        this.wrapped.sendError(sc);
    }

    public void sendRedirect(String location) throws IOException {
        this.wrapped.sendRedirect(location);
    }

    public void setDateHeader(String name, long date) {
        this.wrapped.setDateHeader(name, date);
    }

    public void addDateHeader(String name, long date) {
        this.wrapped.addDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        this.wrapped.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.wrapped.addHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.wrapped.setIntHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.wrapped.addIntHeader(name, value);
    }

    public void setStatus(int sc) {
        this.wrapped.setStatus(sc);
    }

    @Deprecated
    public void setStatus(int sc, String sm) {
        this.wrapped.setStatus(sc, sm);
    }

    public int getStatus() {
        return this.wrapped.getStatus();
    }

    public String getHeader(String name) {
        return this.wrapped.getHeader(name);
    }

    public Collection<String> getHeaders(String name) {
        return this.wrapped.getHeaders(name);
    }

    public Collection<String> getHeaderNames() {
        return this.wrapped.getHeaderNames();
    }

    public String getCharacterEncoding() {
        return this.wrapped.getCharacterEncoding();
    }

    public String getContentType() {
        return this.wrapped.getContentType();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.outputStreamWrapper;
    }

    public PrintWriter getWriter() throws IOException {
        return this.wrapped.getWriter();
    }

    public void setCharacterEncoding(String charset) {
        this.wrapped.setCharacterEncoding(charset);
    }

    public void setContentLength(int len) {
        this.wrapped.setContentLength(len);
    }

    public void setContentLengthLong(long length) {
        this.wrapped.setContentLengthLong(length);
    }

    public void setContentType(String type) {
        this.wrapped.setContentType(type);
    }

    public void setBufferSize(int size) {
        this.wrapped.setBufferSize(size);
    }

    public int getBufferSize() {
        return this.wrapped.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this.wrapped.flushBuffer();
    }

    public void resetBuffer() {
        this.wrapped.resetBuffer();
    }

    public boolean isCommitted() {
        return this.wrapped.isCommitted();
    }

    public void reset() {
        this.wrapped.reset();
    }

    public void setLocale(Locale loc) {
        this.wrapped.setLocale(loc);
    }

    public Locale getLocale() {
        return this.wrapped.getLocale();
    }

    public class OutputStreamWrapper
    extends ServletOutputStream {
        private ServletOutputStream wrapped;
        RequestResponseCaptureWatcher watcher;

        public OutputStreamWrapper(ServletOutputStream wrapped, RequestResponseCaptureWatcher watcher) {
            watcher.withResponseOutputStream(wrapped);
            this.wrapped = wrapped;
            this.watcher = watcher;
        }

        public boolean isReady() {
            return this.wrapped.isReady();
        }

        public void setWriteListener(WriteListener listener) {
            this.wrapped.setWriteListener(listener);
        }

        public void write(int b) throws IOException {
            this.watcher.writeResponse(b);
        }
    }
}

