/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.springboot;

import dev.speakeasyapi.springboot.RequestResponseCaptureWatcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;

public class SpeakeasyRequestWrapper
implements HttpServletRequest {
    public static String speakeasyRequestResponseWatcherAttribute = "speakeasyRequestResponseWatcher";
    private HttpServletRequest wrapped;
    private RequestResponseCaptureWatcher watcher;
    private Cookie[] cachedCookies;
    private Map<String, Collection<String>> cachedHeaders = new HashMap<String, Collection<String>>();
    private Collection<String> cachedHeaderNames;
    private String cachedMethod;
    private String cachedQueryString;
    private String cachedRequestURI;
    private long cachedContentLengthLong = -1L;
    private String cachedContentType;
    private String cachedProtocol;

    public SpeakeasyRequestWrapper(HttpServletRequest wrapped, RequestResponseCaptureWatcher watcher) {
        watcher.withServletRequest(wrapped);
        this.watcher = watcher;
        this.wrapped = wrapped;
        wrapped.setAttribute(speakeasyRequestResponseWatcherAttribute, (Object)watcher);
    }

    public String getAuthType() {
        return this.wrapped.getAuthType();
    }

    public Cookie[] getCookies() {
        if (this.cachedCookies == null) {
            this.cachedCookies = this.wrapped.getCookies();
        }
        return this.cachedCookies;
    }

    public long getDateHeader(String name) {
        return this.wrapped.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.wrapped.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        if (!this.cachedHeaders.containsKey(name)) {
            Enumeration headers = this.wrapped.getHeaders(name);
            ArrayList<String> collection = new ArrayList<String>();
            while (headers.hasMoreElements()) {
                collection.add((String)headers.nextElement());
            }
            this.cachedHeaders.put(name, collection);
        }
        return Collections.enumeration(this.cachedHeaders.get(name));
    }

    public Enumeration<String> getHeaderNames() {
        if (this.cachedHeaderNames == null) {
            Enumeration headerNames = this.wrapped.getHeaderNames();
            ArrayList<String> collection = new ArrayList<String>();
            while (headerNames.hasMoreElements()) {
                try {
                    collection.add((String)headerNames.nextElement());
                }
                catch (NullPointerException e) {
                    // empty catch block
                    break;
                }
            }
            this.cachedHeaderNames = collection;
        }
        return Collections.enumeration(this.cachedHeaderNames);
    }

    public int getIntHeader(String name) {
        return this.wrapped.getIntHeader(name);
    }

    public String getMethod() {
        if (this.cachedMethod == null) {
            this.cachedMethod = this.wrapped.getMethod();
        }
        return this.cachedMethod;
    }

    public String getPathInfo() {
        return this.wrapped.getPathInfo();
    }

    public String getPathTranslated() {
        return this.wrapped.getPathTranslated();
    }

    public String getContextPath() {
        return this.wrapped.getContextPath();
    }

    public String getQueryString() {
        if (this.cachedQueryString == null) {
            this.cachedQueryString = this.wrapped.getQueryString();
        }
        return this.cachedQueryString;
    }

    public String getRemoteUser() {
        return this.wrapped.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this.wrapped.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.wrapped.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.wrapped.getRequestedSessionId();
    }

    public String getRequestURI() {
        if (this.cachedRequestURI == null) {
            this.cachedRequestURI = this.wrapped.getRequestURI();
        }
        return this.cachedRequestURI;
    }

    public StringBuffer getRequestURL() {
        return this.wrapped.getRequestURL();
    }

    public String getServletPath() {
        return this.wrapped.getServletPath();
    }

    public HttpSession getSession(boolean create) {
        return this.wrapped.getSession(create);
    }

    public HttpSession getSession() {
        return this.wrapped.getSession();
    }

    public String changeSessionId() {
        return this.wrapped.changeSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        return this.wrapped.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.wrapped.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.wrapped.isRequestedSessionIdFromURL();
    }

    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        return this.wrapped.isRequestedSessionIdFromUrl();
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return this.wrapped.authenticate(response);
    }

    public void login(String username, String password) throws ServletException {
        this.wrapped.login(username, password);
    }

    public void logout() throws ServletException {
        this.wrapped.logout();
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this.wrapped.getParts();
    }

    public Part getPart(String name) throws IOException, ServletException {
        return this.wrapped.getPart(name);
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> httpUpgradeHandlerClass) throws IOException, ServletException {
        return (T)this.wrapped.upgrade(httpUpgradeHandlerClass);
    }

    public Object getAttribute(String name) {
        return this.wrapped.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.wrapped.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.wrapped.getCharacterEncoding();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.wrapped.setCharacterEncoding(env);
    }

    public int getContentLength() {
        return this.wrapped.getContentLength();
    }

    public long getContentLengthLong() {
        if (this.cachedContentLengthLong == -1L) {
            this.cachedContentLengthLong = this.wrapped.getContentLengthLong();
        }
        return this.cachedContentLengthLong;
    }

    public String getContentType() {
        if (this.cachedContentType == null) {
            this.cachedContentType = this.wrapped.getContentType();
        }
        return this.cachedContentType;
    }

    public ServletInputStream getInputStream() {
        return this.watcher.getCopiedInputStream();
    }

    public String getParameter(String name) {
        return this.wrapped.getParameter(name);
    }

    public Enumeration<String> getParameterNames() {
        return this.wrapped.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.wrapped.getParameterValues(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.wrapped.getParameterMap();
    }

    public String getProtocol() {
        if (this.cachedProtocol == null) {
            this.cachedProtocol = this.wrapped.getProtocol();
        }
        return this.cachedProtocol;
    }

    public String getScheme() {
        return this.wrapped.getScheme();
    }

    public String getServerName() {
        return this.wrapped.getServerName();
    }

    public int getServerPort() {
        return this.wrapped.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        return this.wrapped.getReader();
    }

    public String getRemoteAddr() {
        return this.wrapped.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.wrapped.getRemoteHost();
    }

    public void setAttribute(String name, Object o) {
        this.wrapped.setAttribute(name, o);
    }

    public void removeAttribute(String name) {
        this.wrapped.removeAttribute(name);
    }

    public Locale getLocale() {
        return this.wrapped.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.wrapped.getLocales();
    }

    public boolean isSecure() {
        return this.wrapped.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.wrapped.getRequestDispatcher(path);
    }

    @Deprecated
    public String getRealPath(String path) {
        return this.wrapped.getRealPath(path);
    }

    public int getRemotePort() {
        return this.wrapped.getRemotePort();
    }

    public String getLocalName() {
        return this.wrapped.getLocalName();
    }

    public String getLocalAddr() {
        return this.wrapped.getLocalAddr();
    }

    public int getLocalPort() {
        return this.wrapped.getLocalPort();
    }

    public ServletContext getServletContext() {
        return this.wrapped.getServletContext();
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return this.wrapped.startAsync();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return this.wrapped.startAsync(servletRequest, servletResponse);
    }

    public boolean isAsyncStarted() {
        return this.wrapped.isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this.wrapped.isAsyncSupported();
    }

    public AsyncContext getAsyncContext() {
        return this.wrapped.getAsyncContext();
    }

    public DispatcherType getDispatcherType() {
        return this.wrapped.getDispatcherType();
    }
}

