/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.sdk.utils;

import dev.speakeasyapi.sdk.SpeakeasyCookie;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.BinaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static BinaryOperator<List<String>> merge = new BinaryOperator<List<String>>(){

        @Override
        public List<String> apply(List<String> o, List<String> o2) {
            o.addAll(o2);
            return o;
        }
    };

    public static long calculateHeaderSize(Map<String, List<String>> headers) {
        if (headers == null) {
            return 0L;
        }
        StringBuilder builder = new StringBuilder();
        headers.forEach((key, values) -> {
            for (String value : values) {
                builder.append((String)key).append(": ").append(value).append("\r\n");
            }
        });
        return builder.toString().getBytes().length;
    }

    public static SpeakeasyCookie parseSetCookieString(String cookie, Instant startTime) {
        String[] cookieParts;
        String cookieName = null;
        String cookieValue = null;
        String domain = null;
        String path = null;
        String expires = null;
        boolean httpOnly = false;
        boolean secure = false;
        for (String cookiePart : cookieParts = cookie.split("; ")) {
            String cookieRegex = "([^=]+)=?([^=]*)";
            Pattern pattern = Pattern.compile(cookieRegex);
            Matcher matcher = pattern.matcher(cookiePart);
            block19: while (matcher.find()) {
                String key = matcher.group(1);
                String value = matcher.group(2);
                switch (key.toLowerCase()) {
                    case "domain": {
                        domain = value;
                        continue block19;
                    }
                    case "max-age": {
                        int maxAge = Integer.parseInt(value);
                        Instant expiresTime = startTime.plus((long)maxAge, ChronoUnit.SECONDS);
                        expires = expiresTime.toString();
                        continue block19;
                    }
                    case "expires": {
                        try {
                            SimpleDateFormat inFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                            Date expiresDate = inFormat.parse(value);
                            SimpleDateFormat outFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
                            outFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                            expires = outFormat.format(expiresDate);
                        }
                        catch (Exception exception) {}
                        continue block19;
                    }
                    case "httponly": {
                        httpOnly = true;
                        continue block19;
                    }
                    case "path": {
                        path = value;
                        continue block19;
                    }
                    case "secure": {
                        secure = true;
                        continue block19;
                    }
                }
                cookieName = key;
                cookieValue = value;
            }
        }
        return new SpeakeasyCookie(cookieName, cookieValue, domain, path, expires, httpOnly, secure);
    }
}

