/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.sdk.models;

import dev.speakeasyapi.accesstokens.Embedaccesstoken;
import dev.speakeasyapi.sdk.models.SpeakeasyAccessTokenFilterKey;
import dev.speakeasyapi.sdk.models.SpeakeasyAccessTokenFilterOperator;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SpeakeasyAccessTokenFilterBuilder {
    private List<Embedaccesstoken.EmbedAccessTokenRequest.Filter> filters = new ArrayList<Embedaccesstoken.EmbedAccessTokenRequest.Filter>();

    public SpeakeasyAccessTokenFilterBuilder withFilter(String key, String operator, String value) {
        this.filters.add(Embedaccesstoken.EmbedAccessTokenRequest.Filter.newBuilder().setKey(key).setOperator(operator).setValue(value).build());
        return this;
    }

    public SpeakeasyAccessTokenFilterBuilder withFilter(SpeakeasyAccessTokenFilterKey key, SpeakeasyAccessTokenFilterOperator operator, String value) {
        return this.withFilter(key.toString(), operator.toString(), value);
    }

    public SpeakeasyAccessTokenFilterBuilder withGreaterThanFilter(SpeakeasyAccessTokenFilterKey key, String value) {
        return this.withFilter(key, SpeakeasyAccessTokenFilterOperator.GreaterThan, value);
    }

    public SpeakeasyAccessTokenFilterBuilder withLessThanFilter(SpeakeasyAccessTokenFilterKey key, String value) {
        return this.withFilter(key, SpeakeasyAccessTokenFilterOperator.LessThan, value);
    }

    public SpeakeasyAccessTokenFilterBuilder withEqualityFilter(SpeakeasyAccessTokenFilterKey key, String value) {
        return this.withFilter(key, SpeakeasyAccessTokenFilterOperator.Equality, value);
    }

    public SpeakeasyAccessTokenFilterBuilder withCustomerIdFilter(String customerId) {
        return this.withEqualityFilter(SpeakeasyAccessTokenFilterKey.CustomerId, customerId);
    }

    public SpeakeasyAccessTokenFilterBuilder withTimeFilter(Instant time, SpeakeasyAccessTokenFilterOperator operator) {
        return this.withFilter(SpeakeasyAccessTokenFilterKey.Created, operator, time.toString());
    }

    public List<Embedaccesstoken.EmbedAccessTokenRequest.Filter> build() {
        return this.filters;
    }

    public String toString() {
        return this.filters.stream().map(f -> String.format("%s:%s:%s", f.getKey(), f.getOperator(), f.getValue())).collect(Collectors.joining(";"));
    }
}

