/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.sdk.masking;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Masking {
    private static final String DEFAULT_STRING_MASK = "__masked__";
    private static final String DEFAULT_NUMBER_MASK = "-12321";
    private final String stringFieldMatchRegex = "(\"%s\": *)(\".*?[^\\\\]\")( *[, \\n\\r}]?)";
    private final String numberFieldMatchRegex = "(\"%s\": *)(-?[0-9]+\\.?[0-9]*)( *[, \\n\\r}]?)";
    private Map<String, String> queryStringMasks = new HashMap<String, String>();
    private Map<String, String> requestHeaderMasks = new HashMap<String, String>();
    private Map<String, String> responseHeaderMasks = new HashMap<String, String>();
    private Map<String, String> requestCookieMasks = new HashMap<String, String>();
    private Map<String, String> responseCookieMasks = new HashMap<String, String>();
    private Map<String, String> requestBodyMasksString = new HashMap<String, String>();
    private Map<String, String> responseBodyMasksString = new HashMap<String, String>();
    private Map<String, String> requestBodyMasksNumber = new HashMap<String, String>();
    private Map<String, String> responseBodyMasksNumber = new HashMap<String, String>();

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, String> getQueryStringMasks() {
        return this.queryStringMasks;
    }

    public Map<String, String> getRequestHeaderMasks() {
        return this.requestHeaderMasks;
    }

    public Map<String, String> getResponseHeaderMasks() {
        return this.responseHeaderMasks;
    }

    public Map<String, String> getRequestCookieMasks() {
        return this.requestCookieMasks;
    }

    public Map<String, String> getResponseCookieMasks() {
        return this.responseCookieMasks;
    }

    public Map<String, String> getRequestBodyMasksString() {
        return this.requestBodyMasksString;
    }

    public Map<String, String> getRequestBodyMasksNumber() {
        return this.requestBodyMasksNumber;
    }

    public Map<String, String> getResponseBodyMasksString() {
        return this.responseBodyMasksString;
    }

    public Map<String, String> getResponseBodyMasksNumber() {
        return this.responseBodyMasksNumber;
    }

    public String maskRequestBody(String body, String mimeType) {
        return this.maskBody(body, mimeType, this.requestBodyMasksString, this.requestBodyMasksNumber);
    }

    public String maskResponseBody(String body, String mimeType) {
        return this.maskBody(body, mimeType, this.responseBodyMasksString, this.responseBodyMasksNumber);
    }

    private String maskBody(String body, String mimeType, Map<String, String> stringMasks, Map<String, String> numberMasks) {
        int startIdx;
        String match;
        Matcher matcher;
        Pattern regex;
        if (StringUtils.isBlank(mimeType) || !mimeType.toLowerCase().contains("application/json")) {
            return body;
        }
        for (Map.Entry<String, String> entry : stringMasks.entrySet()) {
            regex = Pattern.compile(String.format("(\"%s\": *)(\".*?[^\\\\]\")( *[, \\n\\r}]?)", Pattern.quote(entry.getKey())), 2);
            matcher = regex.matcher(body);
            while (matcher.find()) {
                match = matcher.group(2);
                startIdx = matcher.start(2);
                body = body.substring(0, startIdx) + '\"' + entry.getValue() + '\"' + body.substring(startIdx + match.length());
            }
        }
        for (Map.Entry<String, String> entry : numberMasks.entrySet()) {
            regex = Pattern.compile(String.format("(\"%s\": *)(-?[0-9]+\\.?[0-9]*)( *[, \\n\\r}]?)", Pattern.quote(entry.getKey())), 2);
            matcher = regex.matcher(body);
            while (matcher.find()) {
                match = matcher.group(2);
                startIdx = matcher.start(2);
                body = body.substring(0, startIdx) + entry.getValue() + body.substring(startIdx + match.length());
            }
        }
        return body;
    }

    private Masking() {
    }

    public static class Builder {
        private Masking masking = new Masking();

        public Masking build() {
            return this.masking;
        }

        public Builder maskQueryStrings(List<String> queryParamNames) {
            for (String queryParamName : queryParamNames) {
                this.masking.queryStringMasks.put(queryParamName, Masking.DEFAULT_STRING_MASK);
            }
            return this;
        }

        public Builder maskQueryStrings(List<String> queryParamNames, String mask) {
            for (String queryParamName : queryParamNames) {
                this.masking.queryStringMasks.put(queryParamName, mask);
            }
            return this;
        }

        public Builder maskQueryStrings(Map<String, String> queryParamMasks) {
            this.masking.queryStringMasks.putAll(queryParamMasks);
            return this;
        }

        public Builder maskRequestHeaders(List<String> headerNames) {
            for (String headerName : headerNames) {
                this.masking.requestHeaderMasks.put(headerName, Masking.DEFAULT_STRING_MASK);
            }
            return this;
        }

        public Builder maskRequestHeaders(List<String> headerNames, String mask) {
            for (String headerName : headerNames) {
                this.masking.requestHeaderMasks.put(headerName, mask);
            }
            return this;
        }

        public Builder maskRequestHeaders(Map<String, String> headerMasks) {
            this.masking.requestHeaderMasks.putAll(headerMasks);
            return this;
        }

        public Builder maskResponseHeaders(List<String> headerNames) {
            for (String headerName : headerNames) {
                this.masking.responseHeaderMasks.put(headerName, Masking.DEFAULT_STRING_MASK);
            }
            return this;
        }

        public Builder maskResponseHeaders(List<String> headerNames, String mask) {
            for (String headerName : headerNames) {
                this.masking.responseHeaderMasks.put(headerName, mask);
            }
            return this;
        }

        public Builder maskResponseHeaders(Map<String, String> headerMasks) {
            this.masking.responseHeaderMasks.putAll(headerMasks);
            return this;
        }

        public Builder maskRequestCookies(List<String> cookieNames) {
            for (String cookieName : cookieNames) {
                this.masking.requestCookieMasks.put(cookieName, Masking.DEFAULT_STRING_MASK);
            }
            return this;
        }

        public Builder maskRequestCookies(List<String> cookieNames, String mask) {
            for (String cookieName : cookieNames) {
                this.masking.requestCookieMasks.put(cookieName, mask);
            }
            return this;
        }

        public Builder maskRequestCookies(Map<String, String> cookieMasks) {
            this.masking.requestCookieMasks.putAll(cookieMasks);
            return this;
        }

        public Builder maskResponseCookies(List<String> cookieNames) {
            for (String cookieName : cookieNames) {
                this.masking.responseCookieMasks.put(cookieName, Masking.DEFAULT_STRING_MASK);
            }
            return this;
        }

        public Builder maskResponseCookies(List<String> cookieNames, String mask) {
            for (String cookieName : cookieNames) {
                this.masking.responseCookieMasks.put(cookieName, mask);
            }
            return this;
        }

        public Builder maskResponseCookies(Map<String, String> cookieMasks) {
            this.masking.responseCookieMasks.putAll(cookieMasks);
            return this;
        }

        public Builder maskRequestBodyStrings(List<String> fieldNames) {
            for (String fieldName : fieldNames) {
                this.masking.requestBodyMasksString.put(fieldName, Masking.DEFAULT_STRING_MASK);
            }
            return this;
        }

        public Builder maskRequestBodyStrings(List<String> fieldNames, String mask) {
            for (String fieldName : fieldNames) {
                this.masking.requestBodyMasksString.put(fieldName, mask);
            }
            return this;
        }

        public Builder maskRequestBodyStrings(Map<String, String> fieldMasks) {
            this.masking.requestBodyMasksString.putAll(fieldMasks);
            return this;
        }

        public Builder maskResponseBodyStrings(List<String> fieldNames) {
            for (String fieldName : fieldNames) {
                this.masking.responseBodyMasksString.put(fieldName, Masking.DEFAULT_STRING_MASK);
            }
            return this;
        }

        public Builder maskResponseBodyStrings(List<String> fieldNames, String mask) {
            for (String fieldName : fieldNames) {
                this.masking.responseBodyMasksString.put(fieldName, mask);
            }
            return this;
        }

        public Builder maskResponseBodyStrings(Map<String, String> fieldMasks) {
            this.masking.responseBodyMasksString.putAll(fieldMasks);
            return this;
        }

        public Builder maskRequestBodyNumbers(List<String> fieldNames) {
            for (String fieldName : fieldNames) {
                this.masking.requestBodyMasksNumber.put(fieldName, Masking.DEFAULT_NUMBER_MASK);
            }
            return this;
        }

        public Builder maskRequestBodyNumbers(List<String> fieldNames, String mask) {
            for (String fieldName : fieldNames) {
                this.masking.requestBodyMasksNumber.put(fieldName, mask);
            }
            return this;
        }

        public Builder maskRequestBodyNumbers(Map<String, String> fieldMasks) {
            this.masking.requestBodyMasksNumber.putAll(fieldMasks);
            return this;
        }

        public Builder maskResponseBodyNumbers(List<String> fieldNames) {
            for (String fieldName : fieldNames) {
                this.masking.responseBodyMasksNumber.put(fieldName, Masking.DEFAULT_NUMBER_MASK);
            }
            return this;
        }

        public Builder maskResponseBodyNumbers(List<String> fieldNames, String mask) {
            for (String fieldName : fieldNames) {
                this.masking.responseBodyMasksNumber.put(fieldName, mask);
            }
            return this;
        }

        public Builder maskResponseBodyNumbers(Map<String, String> fieldMasks) {
            this.masking.responseBodyMasksNumber.putAll(fieldMasks);
            return this;
        }

        private Builder() {
        }
    }
}

