/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.micronaut.implementation;

import dev.speakeasyapi.micronaut.implementation.SpeakeasyRequestContext;
import dev.speakeasyapi.sdk.SpeakeasyConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SpeakeasySingleton {
    private static SpeakeasySingleton INSTANCE;
    private final SpeakeasyConfig cfg = new SpeakeasyConfig();
    private final Map<String, SpeakeasyRequestContext> requests = new ConcurrentHashMap<String, SpeakeasyRequestContext>();

    private SpeakeasySingleton() {
    }

    public static synchronized SpeakeasySingleton getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SpeakeasySingleton();
        }
        return INSTANCE;
    }

    public void configure(String apiKey, String apiID, String versionID) {
        this.cfg.setApiKey(apiKey);
        this.cfg.setApiID(apiID);
        this.cfg.setVersionID(versionID);
    }

    public SpeakeasyConfig getConfig() {
        return this.cfg;
    }

    public void registerRequest(String requestId) {
        this.requests.put(requestId, new SpeakeasyRequestContext(this.cfg));
    }

    public void removeRequest(String requestId) {
        this.requests.remove(requestId);
    }

    public SpeakeasyRequestContext getRequestContext(String requestId) {
        return this.requests.get(requestId);
    }
}

