/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.micronaut.implementation;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

public class SpeakeasyCaptureWriter {
    final int MAX_BUFFER_SIZE = 0x100000;
    private ByteBuf reqBuffer = Unpooled.buffer();
    private ByteBuf resBuffer = Unpooled.buffer();
    private boolean reqValid = true;
    private boolean resValid = true;

    public void writeRequest(ByteBuf content) {
        if (content.equals(Unpooled.EMPTY_BUFFER)) {
            return;
        }
        int readIndex = content.readerIndex();
        int readableBytes = content.readableBytes();
        if (this.reqBuffer.readableBytes() + this.resBuffer.readableBytes() + readableBytes > 0x100000) {
            this.reqValid = false;
        } else if (this.reqValid) {
            this.reqBuffer.ensureWritable(readableBytes);
            content.readBytes(this.reqBuffer, readableBytes);
            content.readerIndex(readIndex);
        }
    }

    public void writeResponse(ByteBuf content) {
        if (content.equals(Unpooled.EMPTY_BUFFER)) {
            return;
        }
        int readIndex = content.readerIndex();
        int readableBytes = content.readableBytes();
        if (this.reqBuffer.readableBytes() + this.resBuffer.readableBytes() + readableBytes > 0x100000) {
            this.resValid = false;
        } else if (this.resValid) {
            this.resBuffer.ensureWritable(readableBytes);
            content.readBytes(this.resBuffer, readableBytes);
            content.readerIndex(readIndex);
        }
    }

    public byte[] getReqBuffer() {
        int length = this.reqBuffer.readableBytes();
        if (length == this.reqBuffer.capacity()) {
            return this.reqBuffer.array();
        }
        byte[] target = new byte[length];
        System.arraycopy(this.reqBuffer.array(), 0, target, 0, length);
        return target;
    }

    public byte[] getResBuffer() {
        int length = this.resBuffer.readableBytes();
        if (length == this.resBuffer.capacity()) {
            return this.resBuffer.array();
        }
        byte[] target = new byte[length];
        System.arraycopy(this.resBuffer.array(), 0, target, 0, length);
        return target;
    }

    public boolean isReqValid() {
        return this.reqValid;
    }

    public boolean isResValid() {
        return this.resValid;
    }
}

