/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.micronaut;

import dev.speakeasyapi.micronaut.EnableSpeakeasy;
import dev.speakeasyapi.micronaut.implementation.SpeakeasySingleton;
import dev.speakeasyapi.sdk.SpeakeasyMiddlewareController;
import io.micronaut.aop.InterceptorBean;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.CustomHttpMethod;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Head;
import io.micronaut.http.annotation.Options;
import io.micronaut.http.annotation.Patch;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Put;
import io.micronaut.http.annotation.Trace;
import jakarta.inject.Singleton;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;

@Singleton
@InterceptorBean(value={EnableSpeakeasy.class})
public class EnableSpeakeasyInterceptor
implements MethodInterceptor<Object, Object> {
    public static void configure(String apiID, String versionID) {
        SpeakeasySingleton.getInstance().configure(null, apiID, versionID);
    }

    public static void configure(String apiID, String versionID, String apiKey) {
        SpeakeasySingleton.getInstance().configure(apiKey, apiID, versionID);
    }

    @Nullable
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        Map parameters = context.getParameterValueMap();
        SpeakeasyMiddlewareController ctrl = null;
        for (Object value : parameters.values()) {
            if (!SpeakeasyMiddlewareController.class.isInstance(value)) continue;
            ctrl = (SpeakeasyMiddlewareController)value;
            break;
        }
        if (ctrl != null) {
            ctrl.setEnabled(true);
            ctrl.setPathHint(EnableSpeakeasyInterceptor.getPathHint(context));
        }
        return context.proceed();
    }

    private static String getPathHint(MethodInvocationContext<Object, Object> context) {
        Trace anno;
        Optional controllerValue;
        String controllerPath = "";
        String pathHint = "";
        AnnotationValue controllerAnno = context.getAnnotation(Controller.class);
        if (controllerAnno != null && (controllerValue = controllerAnno.get((CharSequence)"value", String.class)).isPresent()) {
            controllerPath = (String)controllerValue.get();
            if (pathHint.endsWith("/")) {
                controllerPath = pathHint.substring(0, pathHint.length() - 1);
            }
            if (!controllerPath.startsWith("/")) {
                controllerPath = "/" + controllerPath;
            }
        }
        Method method = context.getTargetMethod();
        String methodPath = "";
        if (method.isAnnotationPresent(CustomHttpMethod.class)) {
            CustomHttpMethod anno2 = method.getAnnotation(CustomHttpMethod.class);
            if (anno2.value() != "") {
                methodPath = anno2.value();
            }
        } else if (method.isAnnotationPresent(Get.class)) {
            Get anno3 = method.getAnnotation(Get.class);
            if (anno3.value() != "") {
                methodPath = anno3.value();
            }
        } else if (method.isAnnotationPresent(Post.class)) {
            Post anno4 = method.getAnnotation(Post.class);
            if (anno4.value() != "") {
                methodPath = anno4.value();
            }
        } else if (method.isAnnotationPresent(Put.class)) {
            Put anno5 = method.getAnnotation(Put.class);
            if (anno5.value() != "") {
                methodPath = anno5.value();
            }
        } else if (method.isAnnotationPresent(Delete.class)) {
            Delete anno6 = method.getAnnotation(Delete.class);
            if (anno6.value() != "") {
                methodPath = anno6.value();
            }
        } else if (method.isAnnotationPresent(Head.class)) {
            Head anno7 = method.getAnnotation(Head.class);
            if (anno7.value() != "") {
                methodPath = anno7.value();
            }
        } else if (method.isAnnotationPresent(Options.class)) {
            Options anno8 = method.getAnnotation(Options.class);
            if (anno8.value() != "") {
                methodPath = anno8.value();
            }
        } else if (method.isAnnotationPresent(Patch.class)) {
            Patch anno9 = method.getAnnotation(Patch.class);
            if (anno9.value() != "") {
                methodPath = anno9.value();
            }
        } else if (method.isAnnotationPresent(Trace.class) && (anno = method.getAnnotation(Trace.class)).value() != "") {
            methodPath = anno.value();
        }
        if (!methodPath.startsWith("/")) {
            methodPath = "/" + methodPath;
        }
        return controllerPath + methodPath;
    }
}

