/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.kafka;

import dev.snowdrop.vertx.kafka.Header;
import dev.snowdrop.vertx.kafka.ProducerRecord;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class SnowdropProducerRecord<K, V>
implements ProducerRecord<K, V> {
    private final K key;
    private final V value;
    private final String topic;
    private final Integer partition;
    private final Long timestamp;
    private final List<Header> headers;

    SnowdropProducerRecord(K key, V value, String topic, Integer partition, Long timestamp, List<Header> headers) {
        this.key = key;
        this.value = value;
        this.topic = topic;
        this.partition = partition;
        this.timestamp = timestamp;
        this.headers = Collections.unmodifiableList(headers);
    }

    @Override
    public K key() {
        return this.key;
    }

    @Override
    public V value() {
        return this.value;
    }

    @Override
    public String topic() {
        return this.topic;
    }

    @Override
    public Integer partition() {
        return this.partition;
    }

    @Override
    public Long timestamp() {
        return this.timestamp;
    }

    @Override
    public List<Header> headers() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnowdropProducerRecord that = (SnowdropProducerRecord)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && Objects.equals(this.topic, that.topic) && Objects.equals(this.partition, that.partition) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value, this.topic, this.partition, this.timestamp, this.headers);
    }
}

