/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.kafka;

import dev.snowdrop.vertx.kafka.Node;
import dev.snowdrop.vertx.kafka.PartitionInfo;
import dev.snowdrop.vertx.kafka.SnowdropNode;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

final class SnowdropPartitionInfo
implements PartitionInfo {
    private final String topic;
    private final long partition;
    private final List<Node> replicas;
    private final List<Node> inSyncReplicas;
    private final Node leader;

    SnowdropPartitionInfo(io.vertx.kafka.client.common.PartitionInfo vertxPartitionInfo) {
        this.topic = vertxPartitionInfo.getTopic();
        this.partition = vertxPartitionInfo.getPartition();
        this.replicas = vertxPartitionInfo.getReplicas() == null ? new LinkedList() : this.convertNodes(vertxPartitionInfo.getReplicas());
        this.inSyncReplicas = vertxPartitionInfo.getInSyncReplicas() == null ? new LinkedList() : this.convertNodes(vertxPartitionInfo.getInSyncReplicas());
        this.leader = vertxPartitionInfo.getLeader() == null ? null : new SnowdropNode(vertxPartitionInfo.getLeader());
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public long getPartition() {
        return this.partition;
    }

    @Override
    public List<Node> getReplicas() {
        return this.replicas;
    }

    @Override
    public List<Node> getInSyncReplicas() {
        return this.inSyncReplicas;
    }

    @Override
    public Node getLeader() {
        return this.leader;
    }

    private List<Node> convertNodes(List<io.vertx.kafka.client.common.Node> vertxNodes) {
        return vertxNodes.stream().map(SnowdropNode::new).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnowdropPartitionInfo that = (SnowdropPartitionInfo)o;
        return this.partition == that.partition && Objects.equals(this.topic, that.topic) && Objects.equals(this.replicas, that.replicas) && Objects.equals(this.inSyncReplicas, that.inSyncReplicas) && Objects.equals(this.leader, that.leader);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.partition, this.replicas, this.inSyncReplicas, this.leader);
    }

    public String toString() {
        return String.format("%s{topic='%s', partition=%d, replicas=%s, inSyncReplicas=%s, leader=%s}", this.getClass().getSimpleName(), this.topic, this.partition, this.replicas, this.inSyncReplicas, this.leader);
    }
}

