/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.kafka;

import dev.snowdrop.vertx.kafka.ConsumerRecord;
import dev.snowdrop.vertx.kafka.Header;
import dev.snowdrop.vertx.kafka.SnowdropHeader;
import dev.snowdrop.vertx.kafka.SnowdropTimestampType;
import dev.snowdrop.vertx.kafka.TimestampType;
import io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

final class SnowdropConsumerRecord<K, V>
implements ConsumerRecord<K, V> {
    private final String topic;
    private final int partition;
    private final long offset;
    private final long timestamp;
    private final TimestampType timestampType;
    private final K key;
    private final V value;
    private final List<Header> headers;

    SnowdropConsumerRecord(KafkaConsumerRecord<K, V> delegate) {
        this.topic = delegate.topic();
        this.partition = delegate.partition();
        this.offset = delegate.offset();
        this.timestamp = delegate.timestamp();
        this.timestampType = delegate.timestampType() == null ? null : new SnowdropTimestampType(delegate.timestampType());
        this.key = delegate.key();
        this.value = delegate.value();
        this.headers = delegate.headers() == null ? new LinkedList<Header>() : delegate.headers().stream().map(SnowdropHeader::new).collect(Collectors.toList());
    }

    @Override
    public String topic() {
        return this.topic;
    }

    @Override
    public int partition() {
        return this.partition;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public TimestampType timestampType() {
        return this.timestampType;
    }

    @Override
    public K key() {
        return this.key;
    }

    @Override
    public V value() {
        return this.value;
    }

    @Override
    public List<Header> headers() {
        return new LinkedList<Header>(this.headers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnowdropConsumerRecord that = (SnowdropConsumerRecord)o;
        return this.partition == that.partition && this.offset == that.offset && this.timestamp == that.timestamp && Objects.equals(this.topic, that.topic) && Objects.equals(this.timestampType, that.timestampType) && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.partition, this.offset, this.timestamp, this.timestampType, this.key, this.value, this.headers);
    }

    public String toString() {
        return String.format("%s{topic='%s', partition=%d, offset=%d, timestamp=%d, timestampType='%s', key='%s', value='%s', headers='%s'}", this.getClass().getSimpleName(), this.topic, this.partition, this.offset, this.timestamp, this.timestampType, this.key, this.value, this.headers);
    }
}

