/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.kafka;

import dev.snowdrop.vertx.kafka.KafkaConsumerFactory;
import dev.snowdrop.vertx.kafka.KafkaProducerFactory;
import dev.snowdrop.vertx.kafka.KafkaProperties;
import dev.snowdrop.vertx.kafka.SnowdropKafkaConsumerFactory;
import dev.snowdrop.vertx.kafka.SnowdropKafkaProducerFactory;
import io.vertx.core.Vertx;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={KafkaProperties.class})
@ConditionalOnBean(value={Vertx.class})
@ConditionalOnProperty(prefix="vertx.kafka", value={"enabled"}, matchIfMissing=true)
public class KafkaAutoConfiguration {
    @Bean
    public KafkaProducerFactory kafkaProducerFactory(KafkaProperties properties, Vertx vertx) {
        return new SnowdropKafkaProducerFactory(io.vertx.mutiny.core.Vertx.newInstance((Vertx)vertx), properties);
    }

    @Bean
    public KafkaConsumerFactory kafkaConsumerFactory(KafkaProperties properties, Vertx vertx) {
        return new SnowdropKafkaConsumerFactory(io.vertx.mutiny.core.Vertx.newInstance((Vertx)vertx), properties);
    }
}

