/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.kafka;

import dev.snowdrop.vertx.kafka.RecordMetadata;
import java.util.Objects;

final class SnowdropRecordMetadata
implements RecordMetadata {
    private final String topic;
    private final long partition;
    private final long offset;
    private final long timestamp;
    private final long checksum;

    SnowdropRecordMetadata(io.vertx.kafka.client.producer.RecordMetadata vertxRecordMetadata) {
        this.topic = vertxRecordMetadata.getTopic();
        this.partition = vertxRecordMetadata.getPartition();
        this.offset = vertxRecordMetadata.getOffset();
        this.timestamp = vertxRecordMetadata.getTimestamp();
        this.checksum = vertxRecordMetadata.checksum();
    }

    @Override
    public String topic() {
        return this.topic;
    }

    @Override
    public long partition() {
        return this.partition;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public long checksum() {
        return this.checksum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnowdropRecordMetadata that = (SnowdropRecordMetadata)o;
        return this.partition == that.partition && this.offset == that.offset && this.timestamp == that.timestamp && this.checksum == that.checksum && Objects.equals(this.topic, that.topic);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.partition, this.offset, this.timestamp, this.checksum);
    }

    public String toString() {
        return String.format("%s{topic='%s', partition=%d, offset=%d, timestamp=%d, checksum=%d}", this.getClass().getSimpleName(), this.topic, this.partition, this.offset, this.timestamp, this.checksum);
    }
}

