/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.kafka;

import dev.snowdrop.vertx.kafka.Partition;
import io.vertx.kafka.client.common.TopicPartition;
import java.util.Objects;
import org.springframework.util.StringUtils;

final class SnowdropPartition
implements Partition {
    private final String topic;
    private final int partition;

    SnowdropPartition(String topic, int partition) {
        if (StringUtils.isEmpty((Object)topic)) {
            throw new IllegalArgumentException("Topic cannot be empty");
        }
        if (partition < 0) {
            throw new IllegalArgumentException("Partition cannot be negative");
        }
        this.topic = topic;
        this.partition = partition;
    }

    SnowdropPartition(TopicPartition topicPartition) {
        this(topicPartition.getTopic(), topicPartition.getPartition());
    }

    @Override
    public String topic() {
        return this.topic;
    }

    @Override
    public int partition() {
        return this.partition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnowdropPartition that = (SnowdropPartition)o;
        return this.partition == that.partition && Objects.equals(this.topic, that.topic);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.partition);
    }

    public String toString() {
        return String.format("%s{topic='%s', partition=%d}", SnowdropPartition.class.getSimpleName(), this.topic, this.partition);
    }
}

