/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.http.client.properties;

import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="vertx.http.client")
public class HttpClientProperties {
    static final String PROPERTIES_PREFIX = "vertx.http.client";
    private final HttpClientOptions delegate = new HttpClientOptions();

    public HttpClientOptions getHttpClientOptions() {
        return new HttpClientOptions(this.delegate);
    }

    public int getSendBufferSize() {
        return this.delegate.getSendBufferSize();
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.delegate.setSendBufferSize(sendBufferSize);
    }

    public int getReceiveBufferSize() {
        return this.delegate.getReceiveBufferSize();
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.delegate.setReceiveBufferSize(receiveBufferSize);
    }

    public boolean isReuseAddress() {
        return this.delegate.isReuseAddress();
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.delegate.setReuseAddress(reuseAddress);
    }

    public boolean isReusePort() {
        return this.delegate.isReusePort();
    }

    public void setReusePort(boolean reusePort) {
        this.delegate.setReusePort(reusePort);
    }

    public int getTrafficClass() {
        return this.delegate.getTrafficClass();
    }

    public void setTrafficClass(int trafficClass) {
        this.delegate.setTrafficClass(trafficClass);
    }

    public boolean getLogActivity() {
        return this.delegate.getLogActivity();
    }

    public void setLogActivity(boolean logEnabled) {
        this.delegate.setLogActivity(logEnabled);
    }

    public boolean isTcpNoDelay() {
        return this.delegate.isTcpNoDelay();
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.delegate.setTcpNoDelay(tcpNoDelay);
    }

    public boolean isTcpKeepAlive() {
        return this.delegate.isTcpKeepAlive();
    }

    public void setTcpKeepAlive(boolean tcpKeepAlive) {
        this.delegate.setTcpKeepAlive(tcpKeepAlive);
    }

    public int getSoLinger() {
        return this.delegate.getSoLinger();
    }

    public void setSoLinger(int soLinger) {
        this.delegate.setSoLinger(soLinger);
    }

    public int getIdleTimeout() {
        return this.delegate.getIdleTimeout();
    }

    public void setIdleTimeout(int idleTimeout) {
        this.delegate.setIdleTimeout(idleTimeout);
    }

    public TimeUnit getIdleTimeoutUnit() {
        return this.delegate.getIdleTimeoutUnit();
    }

    public void setIdleTimeoutUnit(TimeUnit idleTimeoutUnit) {
        this.delegate.setIdleTimeoutUnit(idleTimeoutUnit);
    }

    public boolean isSsl() {
        return this.delegate.isSsl();
    }

    public void setSsl(boolean ssl) {
        this.delegate.setSsl(ssl);
    }

    public Set<String> getEnabledCipherSuites() {
        return this.delegate.getEnabledCipherSuites();
    }

    public void setEnabledCipherSuites(Set<String> enabledCipherSuites) {
        if (enabledCipherSuites != null) {
            enabledCipherSuites.forEach(arg_0 -> ((HttpClientOptions)this.delegate).addEnabledCipherSuite(arg_0));
        }
    }

    public boolean isUseAlpn() {
        return this.delegate.isUseAlpn();
    }

    public void setUseAlpn(boolean useAlpn) {
        this.delegate.setUseAlpn(useAlpn);
    }

    public Set<String> getEnabledSecureTransportProtocols() {
        return this.delegate.getEnabledSecureTransportProtocols();
    }

    public void setEnabledSecureTransportProtocols(Set<String> enabledSecureTransportProtocols) {
        this.delegate.setEnabledSecureTransportProtocols(enabledSecureTransportProtocols);
    }

    public boolean isTcpFastOpen() {
        return this.delegate.isTcpFastOpen();
    }

    public void setTcpFastOpen(boolean tcpFastOpen) {
        this.delegate.setTcpFastOpen(tcpFastOpen);
    }

    public boolean isTcpCork() {
        return this.delegate.isTcpCork();
    }

    public void setTcpCork(boolean tcpCork) {
        this.delegate.setTcpCork(tcpCork);
    }

    public boolean isTcpQuickAck() {
        return this.delegate.isTcpQuickAck();
    }

    public void setTcpQuickAck(boolean tcpQuickAck) {
        this.delegate.setTcpQuickAck(tcpQuickAck);
    }

    public int getConnectTimeout() {
        return this.delegate.getConnectTimeout();
    }

    public void setConnectTimeout(int connectTimeout) {
        this.delegate.setConnectTimeout(connectTimeout);
    }

    public boolean isTrustAll() {
        return this.delegate.isTrustAll();
    }

    public void setTrustAll(boolean trustAll) {
        this.delegate.setTrustAll(trustAll);
    }

    public String getMetricsName() {
        return this.delegate.getMetricsName();
    }

    public void setMetricsName(String metricsName) {
        this.delegate.setMetricsName(metricsName);
    }

    public String getLocalAddress() {
        return this.delegate.getLocalAddress();
    }

    public void setLocalAddress(String localAddress) {
        this.delegate.setLocalAddress(localAddress);
    }

    public boolean isVerifyHost() {
        return this.delegate.isVerifyHost();
    }

    public void setVerifyHost(boolean verifyHost) {
        this.delegate.setVerifyHost(verifyHost);
    }

    public int getMaxPoolSize() {
        return this.delegate.getMaxPoolSize();
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.delegate.setMaxPoolSize(maxPoolSize);
    }

    public boolean isKeepAlive() {
        return this.delegate.isKeepAlive();
    }

    public void setKeepAlive(boolean keepAlive) {
        this.delegate.setKeepAlive(keepAlive);
    }

    public int getKeepAliveTimeout() {
        return this.delegate.getKeepAliveTimeout();
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.delegate.setKeepAliveTimeout(keepAliveTimeout);
    }

    public int getPipeliningLimit() {
        return this.delegate.getPipeliningLimit();
    }

    public void setPipeliningLimit(int limit) {
        this.delegate.setPipeliningLimit(limit);
    }

    public boolean isPipelining() {
        return this.delegate.isPipelining();
    }

    public void setPipelining(boolean pipelining) {
        this.delegate.setPipelining(pipelining);
    }

    public int getHttp2MaxPoolSize() {
        return this.delegate.getHttp2MaxPoolSize();
    }

    public void setHttp2MaxPoolSize(int max) {
        this.delegate.setHttp2MaxPoolSize(max);
    }

    public int getHttp2MultiplexingLimit() {
        return this.delegate.getHttp2MultiplexingLimit();
    }

    public void setHttp2MultiplexingLimit(int limit) {
        this.delegate.setHttp2MultiplexingLimit(limit);
    }

    public int getHttp2ConnectionWindowSize() {
        return this.delegate.getHttp2ConnectionWindowSize();
    }

    public void setHttp2ConnectionWindowSize(int http2ConnectionWindowSize) {
        this.delegate.setHttp2ConnectionWindowSize(http2ConnectionWindowSize);
    }

    public int getHttp2KeepAliveTimeout() {
        return this.delegate.getHttp2KeepAliveTimeout();
    }

    public void setHttp2KeepAliveTimeout(int keepAliveTimeout) {
        this.delegate.setHttp2KeepAliveTimeout(keepAliveTimeout);
    }

    public int getPoolCleanerPeriod() {
        return this.delegate.getPoolCleanerPeriod();
    }

    public void setPoolCleanerPeriod(int poolCleanerPeriod) {
        this.delegate.setPoolCleanerPeriod(poolCleanerPeriod);
    }

    public boolean isTryUseCompression() {
        return this.delegate.isTryUseCompression();
    }

    public void setTryUseCompression(boolean tryUseCompression) {
        this.delegate.setTryUseCompression(tryUseCompression);
    }

    @Deprecated
    public int getMaxWebsocketFrameSize() {
        return this.delegate.getMaxWebSocketFrameSize();
    }

    public int getMaxWebSocketFrameSize() {
        return this.delegate.getMaxWebSocketFrameSize();
    }

    @Deprecated
    public void setMaxWebsocketFrameSize(int maxWebSocketFrameSize) {
        this.delegate.setMaxWebSocketFrameSize(maxWebSocketFrameSize);
    }

    public void setMaxWebSocketFrameSize(int maxWebSocketFrameSize) {
        this.delegate.setMaxWebSocketFrameSize(maxWebSocketFrameSize);
    }

    @Deprecated
    public int getMaxWebsocketMessageSize() {
        return this.delegate.getMaxWebSocketMessageSize();
    }

    public int getMaxWebSocketMessageSize() {
        return this.delegate.getMaxWebSocketMessageSize();
    }

    @Deprecated
    public void setMaxWebsocketMessageSize(int maxWebSocketMessageSize) {
        this.delegate.setMaxWebSocketMessageSize(maxWebSocketMessageSize);
    }

    public void setMaxWebSocketMessageSize(int maxWebSocketMessageSize) {
        this.delegate.setMaxWebSocketMessageSize(maxWebSocketMessageSize);
    }

    public String getDefaultHost() {
        return this.delegate.getDefaultHost();
    }

    public void setDefaultHost(String defaultHost) {
        this.delegate.setDefaultHost(defaultHost);
    }

    public int getDefaultPort() {
        return this.delegate.getDefaultPort();
    }

    public void setDefaultPort(int defaultPort) {
        this.delegate.setDefaultPort(defaultPort);
    }

    public HttpVersion getProtocolVersion() {
        return this.delegate.getProtocolVersion();
    }

    public void setProtocolVersion(HttpVersion protocolVersion) {
        this.delegate.setProtocolVersion(protocolVersion);
    }

    public int getMaxChunkSize() {
        return this.delegate.getMaxChunkSize();
    }

    public void setMaxChunkSize(int maxChunkSize) {
        this.delegate.setMaxChunkSize(maxChunkSize);
    }

    public int getMaxInitialLineLength() {
        return this.delegate.getMaxInitialLineLength();
    }

    public void setMaxInitialLineLength(int maxInitialLineLength) {
        this.delegate.setMaxInitialLineLength(maxInitialLineLength);
    }

    public int getMaxHeaderSize() {
        return this.delegate.getMaxHeaderSize();
    }

    public void setMaxHeaderSize(int maxHeaderSize) {
        this.delegate.setMaxHeaderSize(maxHeaderSize);
    }

    public int getMaxWaitQueueSize() {
        return this.delegate.getMaxWaitQueueSize();
    }

    public void setMaxWaitQueueSize(int maxWaitQueueSize) {
        this.delegate.setMaxWaitQueueSize(maxWaitQueueSize);
    }

    public long getHeaderTableSize() {
        return this.delegate.getInitialSettings().getHeaderTableSize();
    }

    public void setHeaderTableSize(long headerTableSize) {
        this.delegate.getInitialSettings().setHeaderTableSize(headerTableSize);
    }

    public boolean isPushEnabled() {
        return this.delegate.getInitialSettings().isPushEnabled();
    }

    public void setPushEnabled(boolean pushEnabled) {
        this.delegate.getInitialSettings().setPushEnabled(pushEnabled);
    }

    public long getMaxConcurrentStreams() {
        return this.delegate.getInitialSettings().getMaxConcurrentStreams();
    }

    public void setMaxConcurrentStreams(long maxConcurrentStreams) {
        this.delegate.getInitialSettings().setMaxConcurrentStreams(maxConcurrentStreams);
    }

    public int getInitialWindowSize() {
        return this.delegate.getInitialSettings().getInitialWindowSize();
    }

    public void setInitialWindowSize(int initialWindowSize) {
        this.delegate.getInitialSettings().setInitialWindowSize(initialWindowSize);
    }

    public int getMaxFrameSize() {
        return this.delegate.getInitialSettings().getMaxFrameSize();
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.delegate.getInitialSettings().setMaxFrameSize(maxFrameSize);
    }

    public long getMaxHeaderListSize() {
        return this.delegate.getInitialSettings().getMaxHeaderListSize();
    }

    public void setMaxHeaderListSize(long maxHeaderListSize) {
        this.delegate.getInitialSettings().setMaxHeaderListSize(maxHeaderListSize);
    }

    public Map<Integer, Long> getHttp2ExtraSettings() {
        return this.delegate.getInitialSettings().getExtraSettings();
    }

    public void setHttp2ExtraSettings(Map<Integer, Long> http2ExtraSettings) {
        this.delegate.getInitialSettings().setExtraSettings(http2ExtraSettings);
    }

    public List<HttpVersion> getAlpnVersions() {
        return this.delegate.getAlpnVersions();
    }

    public void setAlpnVersions(List<HttpVersion> alpnVersions) {
        this.delegate.setAlpnVersions(alpnVersions);
    }

    public boolean isHttp2ClearTextUpgrade() {
        return this.delegate.isHttp2ClearTextUpgrade();
    }

    public void setHttp2ClearTextUpgrade(boolean value) {
        this.delegate.setHttp2ClearTextUpgrade(value);
    }

    public boolean isSendUnmaskedFrames() {
        return this.delegate.isSendUnmaskedFrames();
    }

    public void setSendUnmaskedFrames(boolean sendUnmaskedFrames) {
        this.delegate.setSendUnmaskedFrames(sendUnmaskedFrames);
    }

    public int getMaxRedirects() {
        return this.delegate.getMaxRedirects();
    }

    public void setMaxRedirects(int maxRedirects) {
        this.delegate.setMaxRedirects(maxRedirects);
    }

    public boolean isForceSni() {
        return this.delegate.isForceSni();
    }

    public void setForceSni(boolean forceSni) {
        this.delegate.setForceSni(forceSni);
    }

    public int getDecoderInitialBufferSize() {
        return this.delegate.getDecoderInitialBufferSize();
    }

    public void setDecoderInitialBufferSize(int decoderInitialBufferSize) {
        this.delegate.setDecoderInitialBufferSize(decoderInitialBufferSize);
    }

    @Deprecated
    public boolean isTryWebsocketDeflateFrameCompression() {
        return this.delegate.getTryWebSocketDeflateFrameCompression();
    }

    public boolean isTryWebSocketDeflateFrameCompression() {
        return this.delegate.getTryWebSocketDeflateFrameCompression();
    }

    @Deprecated
    public void setTryUsePerFrameWebsocketCompression(boolean tryWebSocketDeflateFrameCompression) {
        this.delegate.setTryUsePerFrameWebSocketCompression(tryWebSocketDeflateFrameCompression);
    }

    public void setTryUsePerFrameWebSocketCompression(boolean tryWebSocketDeflateFrameCompression) {
        this.delegate.setTryUsePerFrameWebSocketCompression(tryWebSocketDeflateFrameCompression);
    }

    @Deprecated
    public boolean isTryUsePerMessageWebsocketCompression() {
        return this.delegate.getTryUsePerMessageWebSocketCompression();
    }

    public boolean isTryUsePerMessageWebSocketCompression() {
        return this.delegate.getTryUsePerMessageWebSocketCompression();
    }

    @Deprecated
    public void setTryUsePerMessageWebsocketCompression(boolean tryUsePerMessageWebSocketCompression) {
        this.delegate.setTryUsePerMessageWebSocketCompression(tryUsePerMessageWebSocketCompression);
    }

    public void setTryUsePerMessageWebSocketCompression(boolean tryUsePerMessageWebSocketCompression) {
        this.delegate.setTryUsePerMessageWebSocketCompression(tryUsePerMessageWebSocketCompression);
    }

    @Deprecated
    public int getWebsocketCompressionLevel() {
        return this.delegate.getWebSocketCompressionLevel();
    }

    public int getWebSocketCompressionLevel() {
        return this.delegate.getWebSocketCompressionLevel();
    }

    @Deprecated
    public void setWebsocketCompressionLevel(int webSocketCompressionLevel) {
        this.delegate.setWebSocketCompressionLevel(webSocketCompressionLevel);
    }

    public void setWebSocketCompressionLevel(int webSocketCompressionLevel) {
        this.delegate.setWebSocketCompressionLevel(webSocketCompressionLevel);
    }

    @Deprecated
    public boolean isWebsocketCompressionAllowClientNoContext() {
        return this.delegate.getWebSocketCompressionAllowClientNoContext();
    }

    public boolean isWebSocketCompressionAllowClientNoContext() {
        return this.delegate.getWebSocketCompressionAllowClientNoContext();
    }

    @Deprecated
    public void setWebsocketCompressionAllowClientNoContext(boolean webSocketCompressionAllowClientNoContext) {
        this.delegate.setWebSocketCompressionAllowClientNoContext(webSocketCompressionAllowClientNoContext);
    }

    public void setWebSocketCompressionAllowClientNoContext(boolean webSocketCompressionAllowClientNoContext) {
        this.delegate.setWebSocketCompressionAllowClientNoContext(webSocketCompressionAllowClientNoContext);
    }

    @Deprecated
    public boolean isWebsocketCompressionRequestServerNoContext() {
        return this.delegate.getWebSocketCompressionRequestServerNoContext();
    }

    public boolean isWebSocketCompressionRequestServerNoContext() {
        return this.delegate.getWebSocketCompressionRequestServerNoContext();
    }

    @Deprecated
    public void setWebsocketCompressionRequestServerNoContext(boolean webSocketCompressionRequestServerNoContext) {
        this.delegate.setWebSocketCompressionRequestServerNoContext(webSocketCompressionRequestServerNoContext);
    }

    public void setWebSocketCompressionRequestServerNoContext(boolean webSocketCompressionRequestServerNoContext) {
        this.delegate.setWebSocketCompressionRequestServerNoContext(webSocketCompressionRequestServerNoContext);
    }
}

