/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.http.server;

import dev.snowdrop.vertx.http.server.VertxReactiveWebServerFactory;
import dev.snowdrop.vertx.http.server.properties.AddressCustomizer;
import dev.snowdrop.vertx.http.server.properties.CompressionCustomizer;
import dev.snowdrop.vertx.http.server.properties.HttpServerOptionsCustomizer;
import dev.snowdrop.vertx.http.server.properties.PortCustomizer;
import dev.snowdrop.vertx.http.server.properties.SslCustomizer;
import java.util.Set;
import org.springframework.boot.web.server.AbstractConfigurableWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;

public class VertxReactiveWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<VertxReactiveWebServerFactory>,
Ordered {
    private final Set<HttpServerOptionsCustomizer> userDefinedCustomizers;

    public VertxReactiveWebServerFactoryCustomizer(Set<HttpServerOptionsCustomizer> userDefinedCustomizers) {
        this.userDefinedCustomizers = userDefinedCustomizers;
    }

    public void customize(VertxReactiveWebServerFactory factory) {
        factory.registerHttpServerOptionsCustomizer(new PortCustomizer((AbstractConfigurableWebServerFactory)factory));
        factory.registerHttpServerOptionsCustomizer(new AddressCustomizer((AbstractConfigurableWebServerFactory)factory));
        factory.registerHttpServerOptionsCustomizer(new SslCustomizer((AbstractConfigurableWebServerFactory)factory));
        factory.registerHttpServerOptionsCustomizer(new CompressionCustomizer((AbstractConfigurableWebServerFactory)factory));
        if (this.userDefinedCustomizers != null) {
            this.userDefinedCustomizers.forEach(factory::registerHttpServerOptionsCustomizer);
        }
    }

    public int getOrder() {
        return 1;
    }
}

