/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.http.test;

import dev.snowdrop.vertx.http.client.VertxClientHttpConnector;
import dev.snowdrop.vertx.http.server.VertxReactiveWebServerFactory;
import dev.snowdrop.vertx.http.server.properties.HttpServerProperties;
import java.util.Collection;
import java.util.function.Supplier;
import org.springframework.boot.web.codec.CodecCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.reactive.function.client.ExchangeStrategies;

public class VertxWebTestClientSupplier
implements Supplier<WebTestClient> {
    private final ApplicationContext applicationContext;
    private WebTestClient webTestClient;

    public VertxWebTestClientSupplier(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public WebTestClient get() {
        if (this.webTestClient == null) {
            this.webTestClient = this.createWebTestClient();
        }
        return this.webTestClient;
    }

    private WebTestClient createWebTestClient() {
        VertxClientHttpConnector connector = (VertxClientHttpConnector)this.applicationContext.getBean(VertxClientHttpConnector.class);
        WebTestClient.Builder builder = WebTestClient.bindToServer((ClientHttpConnector)connector);
        String baseUrl = String.format("%s://localhost:%s", this.getProtocol(), this.getPort());
        builder.baseUrl(baseUrl);
        this.customizeWebTestClientCodecs(builder);
        return builder.build();
    }

    private String getProtocol() {
        boolean isSsl;
        VertxReactiveWebServerFactory factory = (VertxReactiveWebServerFactory)this.applicationContext.getBean(VertxReactiveWebServerFactory.class);
        if (factory.getSsl() != null) {
            isSsl = factory.getSsl().isEnabled();
        } else {
            HttpServerProperties serverProperties = (HttpServerProperties)this.applicationContext.getBean(HttpServerProperties.class);
            isSsl = serverProperties.isSsl();
        }
        return isSsl ? "https" : "http";
    }

    private String getPort() {
        return this.applicationContext.getEnvironment().getProperty("local.server.port", "8080");
    }

    private void customizeWebTestClientCodecs(WebTestClient.Builder builder) {
        Collection customizers = this.applicationContext.getBeansOfType(CodecCustomizer.class).values();
        ExchangeStrategies strategies = ExchangeStrategies.builder().codecs(codecs -> customizers.forEach(customizer -> customizer.customize((CodecConfigurer)codecs))).build();
        builder.exchangeStrategies(strategies);
    }
}

