/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.amqp;

import dev.snowdrop.vertx.amqp.AmqpConnection;
import dev.snowdrop.vertx.amqp.AmqpMessage;
import dev.snowdrop.vertx.amqp.AmqpSender;
import dev.snowdrop.vertx.amqp.MessageConverter;
import dev.snowdrop.vertx.amqp.SnowdropAmqpConnection;
import io.smallrye.mutiny.converters.uni.UniReactorConverters;
import io.vertx.core.streams.WriteStream;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.publisher.Mono;

class SnowdropAmqpSender
implements AmqpSender {
    private final io.vertx.mutiny.amqp.AmqpSender delegate;
    private final MessageConverter messageConverter;

    SnowdropAmqpSender(io.vertx.mutiny.amqp.AmqpSender delegate, MessageConverter messageConverter) {
        this.delegate = delegate;
        this.messageConverter = messageConverter;
    }

    public WriteStream vertxWriteStream() {
        return this.delegate.getDelegate();
    }

    @Override
    public AmqpSender exceptionHandler(Consumer<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public AmqpSender drainHandler(Consumer<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    @Override
    public AmqpSender setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public boolean writeQueueFull() {
        return this.delegate.writeQueueFull();
    }

    public Mono<Void> write(AmqpMessage message) {
        return (Mono)this.delegate.write(this.messageConverter.toMutinyMessage(message)).convert().with((Function)UniReactorConverters.toMono());
    }

    public Mono<Void> end() {
        return (Mono)this.delegate.end().convert().with((Function)UniReactorConverters.toMono());
    }

    public Mono<Void> end(AmqpMessage message) {
        return (Mono)this.delegate.end(this.messageConverter.toMutinyMessage(message)).convert().with((Function)UniReactorConverters.toMono());
    }

    @Override
    public AmqpSender send(AmqpMessage message) {
        this.delegate.send(this.messageConverter.toMutinyMessage(message));
        return this;
    }

    @Override
    public Mono<Void> sendWithAck(AmqpMessage message) {
        return (Mono)this.delegate.sendWithAck(this.messageConverter.toMutinyMessage(message)).convert().with((Function)UniReactorConverters.toMono());
    }

    @Override
    public AmqpConnection connection() {
        return new SnowdropAmqpConnection(this.delegate.connection(), this.messageConverter);
    }

    @Override
    public String address() {
        return this.delegate.address();
    }

    @Override
    public Mono<Void> close() {
        return (Mono)this.delegate.close().convert().with((Function)UniReactorConverters.toMono());
    }
}

