/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.amqp;

import dev.snowdrop.vertx.amqp.AmqpConnection;
import dev.snowdrop.vertx.amqp.AmqpReceiver;
import dev.snowdrop.vertx.amqp.AmqpReceiverOptions;
import dev.snowdrop.vertx.amqp.AmqpSender;
import dev.snowdrop.vertx.amqp.AmqpSenderOptions;
import dev.snowdrop.vertx.amqp.MessageConverter;
import dev.snowdrop.vertx.amqp.SnowdropAmqpReceiver;
import dev.snowdrop.vertx.amqp.SnowdropAmqpSender;
import io.smallrye.mutiny.converters.uni.UniReactorConverters;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.publisher.Mono;

class SnowdropAmqpConnection
implements AmqpConnection {
    private final io.vertx.mutiny.amqp.AmqpConnection delegate;
    private final MessageConverter messageConverter;

    SnowdropAmqpConnection(io.vertx.mutiny.amqp.AmqpConnection delegate, MessageConverter messageConverter) {
        this.delegate = delegate;
        this.messageConverter = messageConverter;
    }

    @Override
    public AmqpConnection exceptionHandler(Consumer<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public Mono<AmqpSender> createSender(String address) {
        return ((Mono)this.delegate.createSender(address).convert().with((Function)UniReactorConverters.toMono())).map(delegateSender -> new SnowdropAmqpSender((io.vertx.mutiny.amqp.AmqpSender)delegateSender, this.messageConverter));
    }

    @Override
    public Mono<AmqpSender> createSender(String address, AmqpSenderOptions options) {
        return ((Mono)this.delegate.createSender(address, options.toVertxAmqpSenderOptions()).convert().with((Function)UniReactorConverters.toMono())).map(delegateSender -> new SnowdropAmqpSender((io.vertx.mutiny.amqp.AmqpSender)delegateSender, this.messageConverter));
    }

    @Override
    public Mono<AmqpSender> createAnonymousSender() {
        return ((Mono)this.delegate.createAnonymousSender().convert().with((Function)UniReactorConverters.toMono())).map(delegateSender -> new SnowdropAmqpSender((io.vertx.mutiny.amqp.AmqpSender)delegateSender, this.messageConverter));
    }

    @Override
    public Mono<AmqpReceiver> createReceiver(String address) {
        return ((Mono)this.delegate.createReceiver(address).convert().with((Function)UniReactorConverters.toMono())).map(delegateReceiver -> new SnowdropAmqpReceiver((io.vertx.mutiny.amqp.AmqpReceiver)delegateReceiver, this.messageConverter));
    }

    @Override
    public Mono<AmqpReceiver> createReceiver(String address, AmqpReceiverOptions options) {
        return ((Mono)this.delegate.createReceiver(address, options.toVertxAmqpReceiverOptions()).convert().with((Function)UniReactorConverters.toMono())).map(delegateReceiver -> new SnowdropAmqpReceiver((io.vertx.mutiny.amqp.AmqpReceiver)delegateReceiver, this.messageConverter));
    }

    @Override
    public Mono<AmqpReceiver> createDynamicReceiver() {
        return ((Mono)this.delegate.createDynamicReceiver().convert().with((Function)UniReactorConverters.toMono())).map(delegateReceiver -> new SnowdropAmqpReceiver((io.vertx.mutiny.amqp.AmqpReceiver)delegateReceiver, this.messageConverter));
    }

    @Override
    public Mono<Void> close() {
        return (Mono)this.delegate.close().convert().with((Function)UniReactorConverters.toMono());
    }
}

