/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.sample.kafka;

import dev.snowdrop.vertx.sample.kafka.KafkaLog;
import dev.snowdrop.vertx.sample.kafka.KafkaLogger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
public class Controller {
    private final KafkaLogger logger;
    private final KafkaLog log;

    public Controller(KafkaLogger logger, KafkaLog log) {
        this.logger = logger;
        this.log = log;
    }

    @GetMapping(produces={"text/event-stream"})
    public Flux<String> getMessages() {
        return Flux.fromIterable((Iterable)this.log.getMessages());
    }

    @PostMapping
    public Mono<Void> logMessage(@RequestBody String body) {
        return this.logger.logMessage(body.trim());
    }
}

