/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.sample.kafka;

import dev.snowdrop.vertx.kafka.ConsumerRecord;
import dev.snowdrop.vertx.kafka.KafkaConsumer;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import reactor.core.Disposable;

final class KafkaLog
implements InitializingBean,
DisposableBean {
    private final List<String> messages = new CopyOnWriteArrayList();
    private final KafkaConsumer<String, String> consumer;
    private Disposable consumerDisposer;

    KafkaLog(KafkaConsumer<String, String> consumer) {
        this.consumer = consumer;
    }

    public void afterPropertiesSet() {
        this.consumerDisposer = this.consumer.subscribe("log").thenMany((Publisher)this.consumer.flux()).log("Kafka log consumer").map(ConsumerRecord::value).subscribe(this.messages::add);
    }

    public void destroy() {
        if (this.consumerDisposer != null) {
            this.consumerDisposer.dispose();
        }
        this.consumer.unsubscribe().block(Duration.ofSeconds(2L));
    }

    public List<String> getMessages() {
        return this.messages;
    }
}

