/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.sample.http;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

@SpringBootApplication
public class HttpSampleApplication {
    public static void main(String[] args) {
        SpringApplication.run(HttpSampleApplication.class, (String[])args);
    }

    @Bean
    public RouterFunction<ServerResponse> helloRouter() {
        return RouterFunctions.route().GET("/hello", arg_0 -> this.helloHandler(arg_0)).build();
    }

    private Mono<ServerResponse> helloHandler(ServerRequest request) {
        String name = request.queryParam("name").orElse("World");
        String message = String.format("Hello, %s!", name);
        return ServerResponse.ok().body(BodyInserters.fromValue((Object)message));
    }
}

