/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.sample.chunked;

import dev.snowdrop.vertx.mail.MailClient;
import dev.snowdrop.vertx.mail.MailMessage;
import dev.snowdrop.vertx.mail.MailResult;
import dev.snowdrop.vertx.mail.SimpleMailMessage;
import java.time.Duration;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ServerWebInputException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class DataHandler {
    private static final String FROM_ADDRESS = "examples@snowdrop.dev";
    private final MailClient mailClient;
    private final WebClient client;

    public DataHandler(MailClient mailClient, WebClient.Builder clientBuilder) {
        this.mailClient = mailClient;
        this.client = clientBuilder.baseUrl("https://httpbin.org").build();
    }

    public Mono<ServerResponse> get(ServerRequest request) {
        String count = (String)request.queryParam("count").orElseThrow(() -> new ServerWebInputException("Count is required"));
        String email = (String)request.queryParam("email").orElseThrow(() -> new ServerWebInputException("Email is required"));
        System.out.println(String.format("Request for %s entries", count));
        Flux chunks = this.client.get().uri("/stream/{count}", new Object[]{count}).retrieve().bodyToFlux(String.class).log().delayElements(Duration.ofMillis(200L)).publish().refCount(2);
        chunks.buffer(10).flatMap(entries -> this.sendEmail(email, entries)).subscribe();
        return ServerResponse.ok().contentType(MediaType.APPLICATION_JSON).body((Publisher)chunks, String.class);
    }

    private Mono<MailResult> sendEmail(String address, List<String> entries) {
        System.out.println("Sending an email with " + entries.size() + " entries to " + address);
        SimpleMailMessage message = new SimpleMailMessage().setFrom(FROM_ADDRESS).addTo(new String[]{address}).setSubject(String.format("%d entries from httpbin", entries.size())).setText(String.join((CharSequence)", ", entries));
        return this.mailClient.send((MailMessage)message);
    }
}

