/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.sample.amqp;

import dev.snowdrop.vertx.sample.amqp.MessagesManager;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
public class Controller {
    private final MessagesManager messagesManager;

    public Controller(MessagesManager messagesManager) {
        this.messagesManager = messagesManager;
    }

    @GetMapping(produces={"text/event-stream"})
    public Flux<String> getProcessedMessages() {
        return Flux.fromIterable((Iterable)this.messagesManager.getProcessedMessages());
    }

    @PostMapping
    public Mono<Void> submitMessageForProcessing(@RequestBody String body) {
        return this.messagesManager.processMessage(body.trim());
    }
}

