/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.sample.amqp;

import dev.snowdrop.vertx.amqp.AmqpClient;
import dev.snowdrop.vertx.amqp.AmqpMessage;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;

@Component
public class MessagesManager
implements InitializingBean,
DisposableBean {
    private final Logger logger = LoggerFactory.getLogger(MessagesManager.class);
    private final List<String> processedMessages = new CopyOnWriteArrayList();
    private final AmqpClient client;
    private Disposable receiverDisposer;

    public MessagesManager(AmqpClient client, EmbeddedActiveMQ server) {
        this.client = client;
    }

    public void afterPropertiesSet() {
        this.receiverDisposer = this.client.createReceiver("processing-results").flatMapMany(receiver -> receiver.flux().doOnCancel(() -> receiver.close().block())).subscribe(arg_0 -> this.handleMessage(arg_0));
    }

    public void destroy() {
        if (this.receiverDisposer != null) {
            this.receiverDisposer.dispose();
        }
    }

    public List<String> getProcessedMessages() {
        return this.processedMessages;
    }

    public Mono<Void> processMessage(String body) {
        this.logger.info("Sending message '{}' for processing", (Object)body);
        AmqpMessage message = AmqpMessage.create().withBody(body).build();
        return this.client.createSender("processing-requests").flatMap(sender -> sender.sendWithAck(message).then(sender.close()));
    }

    private void handleMessage(AmqpMessage message) {
        String body = message.bodyAsString();
        this.logger.info("Received processed message '{}'", (Object)body);
        this.processedMessages.add(body);
    }
}

