/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.sample.amqp;

import dev.snowdrop.vertx.amqp.AmqpClient;
import dev.snowdrop.vertx.amqp.AmqpMessage;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;

@Component
public class UppercaseProcessor
implements InitializingBean,
DisposableBean {
    private final Logger logger = LoggerFactory.getLogger(UppercaseProcessor.class);
    private final AmqpClient client;
    private Disposable receiverDisposer;

    public UppercaseProcessor(AmqpClient client, EmbeddedActiveMQ server) {
        this.client = client;
    }

    public void afterPropertiesSet() {
        this.receiverDisposer = this.client.createReceiver("processing-requests").flatMapMany(receiver -> receiver.flux().doOnCancel(() -> receiver.close().block())).flatMap(arg_0 -> this.handleMessage(arg_0)).subscribe();
    }

    public void destroy() {
        if (this.receiverDisposer != null) {
            this.receiverDisposer.dispose();
        }
    }

    private Mono<Void> handleMessage(AmqpMessage originalMessage) {
        this.logger.info("Processing '{}'", (Object)originalMessage.bodyAsString());
        AmqpMessage processedMessage = AmqpMessage.create().withBody(originalMessage.bodyAsString().toUpperCase()).build();
        return this.client.createSender("processing-results").flatMap(sender -> sender.sendWithAck(processedMessage).then(sender.close()));
    }
}

