/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.sample.amqp;

import dev.snowdrop.vertx.amqp.AmqpClient;
import dev.snowdrop.vertx.amqp.AmqpMessage;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import reactor.core.Disposable;

final class AmqpLog
implements InitializingBean,
DisposableBean {
    private final List<String> messages = new CopyOnWriteArrayList();
    private final AmqpClient client;
    private Disposable receiverDisposer;

    AmqpLog(AmqpClient client) {
        this.client = client;
    }

    public void afterPropertiesSet() {
        this.receiverDisposer = this.client.createReceiver("messages").flatMapMany(receiver -> receiver.flux().doOnCancel(() -> receiver.close().block())).subscribe(arg_0 -> this.handleMessage(arg_0));
    }

    public void destroy() {
        if (this.receiverDisposer != null) {
            this.receiverDisposer.dispose();
        }
    }

    public List<String> getMessages() {
        return this.messages;
    }

    private void handleMessage(AmqpMessage message) {
        System.out.println("Received log message '" + message.bodyAsString() + "'");
        this.messages.add(message.bodyAsString());
    }
}

