/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.sample.amqp;

import dev.snowdrop.vertx.amqp.AmqpClient;
import dev.snowdrop.vertx.sample.amqp.AmqpLog;
import dev.snowdrop.vertx.sample.amqp.AmqpLogger;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;

@SpringBootApplication
public class AmqpSampleApplication {
    static final String QUEUE = "messages";

    public static void main(String[] args) {
        SpringApplication.run(AmqpSampleApplication.class, (String[])args);
    }

    @Bean
    public AmqpLogger amqpLogger(AmqpClient client, EmbeddedActiveMQ server) {
        return new AmqpLogger(client);
    }

    @Bean
    public AmqpLog amqpLog(AmqpClient client, EmbeddedActiveMQ server) {
        return new AmqpLog(client);
    }

    @Bean(destroyMethod="stop")
    public EmbeddedActiveMQ embeddedBroker() throws Exception {
        return new EmbeddedActiveMQ().start();
    }
}

