/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.boot.narayana.openshift.recovery;

import dev.snowdrop.boot.narayana.openshift.recovery.LogScrapingRecoveryErrorDetector;
import dev.snowdrop.boot.narayana.openshift.recovery.NarayanaRecoveryTerminationController;
import dev.snowdrop.boot.narayana.openshift.recovery.PodStatusManager;
import dev.snowdrop.boot.narayana.openshift.recovery.RecoveryErrorDetector;
import dev.snowdrop.boot.narayana.openshift.recovery.ServiceShutdownController;
import dev.snowdrop.boot.narayana.openshift.recovery.StatefulsetRecoveryControllerAutoConfiguration;
import dev.snowdrop.boot.narayana.openshift.recovery.StatefulsetRecoveryControllerProperties;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;

@AutoConfiguration(after={StatefulsetRecoveryControllerAutoConfiguration.class})
@ConditionalOnBean(value={PodStatusManager.class})
public class NarayanaRecoveryTerminationControllerAutoConfiguration {
    @Bean(initMethod="start", destroyMethod="stop")
    @DependsOn(value={"recoveryManagerService"})
    @ConditionalOnMissingBean(value={NarayanaRecoveryTerminationController.class})
    public NarayanaRecoveryTerminationController narayanaRecoveryTerminationController(PodStatusManager podStatusManager, ObjectProvider<List<ServiceShutdownController>> shutdownControllers, ObjectProvider<List<RecoveryErrorDetector>> recoveryErrorDetectors) {
        return new NarayanaRecoveryTerminationController(podStatusManager, (List)shutdownControllers.getIfAvailable(List::of), (List)recoveryErrorDetectors.getIfAvailable(List::of));
    }

    @Bean
    @ConditionalOnProperty(value={"snowdrop.narayana.openshift.recovery.log-scraping-error-detection-enabled"}, matchIfMissing=true)
    @ConditionalOnMissingBean(value={LogScrapingRecoveryErrorDetector.class})
    public LogScrapingRecoveryErrorDetector logScrapingRecoveryErrorDetector(StatefulsetRecoveryControllerProperties properties, KubernetesClient kubernetesClient) {
        return new LogScrapingRecoveryErrorDetector(properties.getCurrentPodName(), properties.getLogScrapingErrorDetectionPattern(), kubernetesClient);
    }
}

