/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.boot.narayana.openshift.recovery.camel;

import dev.snowdrop.boot.narayana.openshift.recovery.NarayanaRecoveryTerminationControllerAutoConfiguration;
import dev.snowdrop.boot.narayana.openshift.recovery.ServiceShutdownController;
import org.apache.camel.CamelContext;
import org.apache.camel.ServiceStatus;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@AutoConfigureBefore(value={NarayanaRecoveryTerminationControllerAutoConfiguration.class})
public class CamelServiceShutdownControllerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={CamelServiceShutdownController.class})
    public CamelServiceShutdownController camelShutdownHook(CamelContext camelContext) {
        return new CamelServiceShutdownController(camelContext);
    }

    public static class CamelServiceShutdownController
    implements ServiceShutdownController {
        private static final Logger LOG = LoggerFactory.getLogger(CamelServiceShutdownController.class);
        private CamelContext camelContext;

        public CamelServiceShutdownController(CamelContext camelContext) {
            this.camelContext = camelContext;
        }

        @Override
        public void stop() throws InterruptedException {
            LOG.info("Waiting for Camel context to stop...");
            int attempts = 200;
            boolean forcedShutdown = false;
            ServiceStatus camelStatus = this.camelContext.getStatus();
            for (int i = 0; i < attempts && !camelStatus.isStopped(); ++i) {
                if (i == 0 || forcedShutdown || camelStatus.isStopping()) {
                    LOG.debug("Camel context still running, waiting 1 second more...");
                } else {
                    try {
                        LOG.info("Forcing Camel context shutdown...");
                        this.camelContext.stop();
                        forcedShutdown = true;
                    }
                    catch (Exception ex) {
                        LOG.warn("Unable to stop Camel context", (Throwable)ex);
                    }
                }
                Thread.sleep(1000L);
                camelStatus = this.camelContext.getStatus();
            }
            if (!camelStatus.isStopped()) {
                throw new IllegalStateException("Camel context not stopped after " + attempts + " seconds");
            }
            LOG.info("Camel context stopped");
        }
    }
}

