/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.boot.narayana.openshift.recovery;

import dev.snowdrop.boot.narayana.openshift.recovery.PodStatusManager;
import dev.snowdrop.boot.narayana.openshift.recovery.StatefulsetRecoveryController;
import dev.snowdrop.boot.narayana.openshift.recovery.StatefulsetRecoveryControllerProperties;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@EnableScheduling
@EnableConfigurationProperties(value={StatefulsetRecoveryControllerProperties.class})
@ConditionalOnProperty(value={"snowdrop.narayana.openshift.recovery.enabled"})
public class StatefulsetRecoveryControllerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={PodStatusManager.class})
    public PodStatusManager podStatusManager(StatefulsetRecoveryControllerProperties properties) {
        return new PodStatusManager(properties);
    }

    @Bean(destroyMethod="close")
    @ConditionalOnMissingBean(value={KubernetesClient.class})
    public KubernetesClient kubernetesClient() {
        return new DefaultOpenShiftClient();
    }

    @Bean
    @ConditionalOnMissingBean(value={StatefulsetRecoveryController.class})
    public StatefulsetRecoveryController statefulsetRecoveryController(StatefulsetRecoveryControllerProperties properties, PodStatusManager podStatusManager, KubernetesClient kubernetesClient) {
        return new StatefulsetRecoveryController(properties, podStatusManager, kubernetesClient);
    }
}

