/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.boot.narayana.openshift.recovery;

import dev.snowdrop.boot.narayana.openshift.recovery.LogScrapingRecoveryErrorDetector;
import dev.snowdrop.boot.narayana.openshift.recovery.NarayanaRecoveryTerminationController;
import dev.snowdrop.boot.narayana.openshift.recovery.PodStatusManager;
import dev.snowdrop.boot.narayana.openshift.recovery.RecoveryErrorDetector;
import dev.snowdrop.boot.narayana.openshift.recovery.ServiceShutdownController;
import dev.snowdrop.boot.narayana.openshift.recovery.StatefulsetRecoveryControllerAutoConfiguration;
import dev.snowdrop.boot.narayana.openshift.recovery.StatefulsetRecoveryControllerProperties;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@AutoConfigureAfter(value={StatefulsetRecoveryControllerAutoConfiguration.class})
@ConditionalOnBean(value={PodStatusManager.class})
public class NarayanaRecoveryTerminationControllerAutoConfiguration {
    @Bean(initMethod="start", destroyMethod="stop")
    @DependsOn(value={"recoveryManagerService"})
    @ConditionalOnMissingBean(value={NarayanaRecoveryTerminationController.class})
    public NarayanaRecoveryTerminationController narayanaRecoveryTerminationController(PodStatusManager podStatusManager, Optional<List<ServiceShutdownController>> shutdownControllers, Optional<List<RecoveryErrorDetector>> recoveryErrorDetectors) {
        return new NarayanaRecoveryTerminationController(podStatusManager, shutdownControllers.orElse(Collections.emptyList()), recoveryErrorDetectors.orElse(Collections.emptyList()));
    }

    @Bean
    @ConditionalOnProperty(value={"snowdrop.narayana.openshift.recovery.log-scraping-error-detection-enabled"}, matchIfMissing=true)
    @ConditionalOnMissingBean(value={LogScrapingRecoveryErrorDetector.class})
    public LogScrapingRecoveryErrorDetector logScrapingRecoveryErrorDetector(StatefulsetRecoveryControllerProperties properties, KubernetesClient kubernetesClient) {
        return new LogScrapingRecoveryErrorDetector(properties.getCurrentPodName(), properties.getLogScrapingErrorDetectionPattern(), kubernetesClient);
    }
}

